/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.registration;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.springframework.cache.Cache;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.security.saml2.provider.service.registration.IterableRelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.util.Assert;

public final class CachingRelyingPartyRegistrationRepository
implements IterableRelyingPartyRegistrationRepository {
    private final Callable<IterableRelyingPartyRegistrationRepository> registrationLoader;
    private Cache cache = new ConcurrentMapCache("registrations");

    public CachingRelyingPartyRegistrationRepository(Callable<IterableRelyingPartyRegistrationRepository> loader) {
        this.registrationLoader = loader;
    }

    @Override
    public Iterator<RelyingPartyRegistration> iterator() {
        return this.registrations().iterator();
    }

    @Override
    public RelyingPartyRegistration findByRegistrationId(String registrationId) {
        return this.registrations().findByRegistrationId(registrationId);
    }

    @Override
    public RelyingPartyRegistration findUniqueByAssertingPartyEntityId(String entityId) {
        return this.registrations().findUniqueByAssertingPartyEntityId(entityId);
    }

    @Override
    public void forEach(Consumer<? super RelyingPartyRegistration> action) {
        this.registrations().forEach(action);
    }

    @Override
    public Spliterator<RelyingPartyRegistration> spliterator() {
        return this.registrations().spliterator();
    }

    private IterableRelyingPartyRegistrationRepository registrations() {
        return (IterableRelyingPartyRegistrationRepository)this.cache.get((Object)"registrations", this.registrationLoader);
    }

    public void setCache(Cache cache) {
        Assert.notNull((Object)cache, (String)"cache cannot be null");
        this.cache = cache;
    }
}

