/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.web;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public final class RelyingPartyRegistrationPlaceholderResolvers {
    private static final char PATH_DELIMITER = '/';

    private RelyingPartyRegistrationPlaceholderResolvers() {
    }

    public static UriResolver uriResolver(HttpServletRequest request) {
        return new UriResolver(RelyingPartyRegistrationPlaceholderResolvers.uriVariables(request));
    }

    public static UriResolver uriResolver(HttpServletRequest request, RelyingPartyRegistration registration) {
        String relyingPartyEntityId = registration.getEntityId();
        String assertingPartyEntityId = registration.getAssertingPartyMetadata().getEntityId();
        String registrationId = registration.getRegistrationId();
        Map<String, String> uriVariables = RelyingPartyRegistrationPlaceholderResolvers.uriVariables(request);
        uriVariables.put("relyingPartyEntityId", StringUtils.hasText((String)relyingPartyEntityId) ? relyingPartyEntityId : "");
        uriVariables.put("assertingPartyEntityId", StringUtils.hasText((String)assertingPartyEntityId) ? assertingPartyEntityId : "");
        uriVariables.put("entityId", StringUtils.hasText((String)assertingPartyEntityId) ? assertingPartyEntityId : "");
        uriVariables.put("registrationId", StringUtils.hasText((String)registrationId) ? registrationId : "");
        return new UriResolver(uriVariables);
    }

    private static Map<String, String> uriVariables(HttpServletRequest request) {
        String baseUrl = RelyingPartyRegistrationPlaceholderResolvers.getApplicationUri(request);
        HashMap<String, String> uriVariables = new HashMap<String, String>();
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)baseUrl).replaceQuery(null).fragment(null).build();
        String scheme = uriComponents.getScheme();
        uriVariables.put("baseScheme", scheme != null ? scheme : "");
        String host = uriComponents.getHost();
        uriVariables.put("baseHost", host != null ? host : "");
        int port = uriComponents.getPort();
        uriVariables.put("basePort", (String)(port == -1 ? "" : ":" + port));
        Object path = uriComponents.getPath();
        if (StringUtils.hasLength((String)path) && ((String)path).charAt(0) != '/') {
            path = "/" + (String)path;
        }
        uriVariables.put("basePath", (String)(path != null ? path : ""));
        uriVariables.put("baseUrl", uriComponents.toUriString());
        return uriVariables;
    }

    private static String getApplicationUri(HttpServletRequest request) {
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).replacePath(request.getContextPath()).replaceQuery(null).fragment(null).build();
        return uriComponents.toUriString();
    }

    public static final class UriResolver {
        private final Map<String, String> uriVariables;

        private UriResolver(Map<String, String> uriVariables) {
            this.uriVariables = uriVariables;
        }

        public String resolve(String uri) {
            if (uri == null) {
                return null;
            }
            return UriComponentsBuilder.fromUriString((String)uri).buildAndExpand(this.uriVariables).toUriString();
        }
    }
}

