/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.token;

import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.UUID;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.jose.jws.JwsAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.JwsHeader;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.JwtEncoderParameters;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class JwtGenerator
implements OAuth2TokenGenerator<Jwt> {
    private final JwtEncoder jwtEncoder;
    private OAuth2TokenCustomizer<JwtEncodingContext> jwtCustomizer;
    private Clock clock = Clock.systemUTC();

    public JwtGenerator(JwtEncoder jwtEncoder) {
        Assert.notNull((Object)jwtEncoder, (String)"jwtEncoder cannot be null");
        this.jwtEncoder = jwtEncoder;
    }

    @Override
    @Nullable
    public Jwt generate(OAuth2TokenContext context) {
        SessionInformation sessionInformation;
        Instant expiresAt;
        if (context.getTokenType() == null || !OAuth2TokenType.ACCESS_TOKEN.equals(context.getTokenType()) && !"id_token".equals(context.getTokenType().getValue())) {
            return null;
        }
        if (OAuth2TokenType.ACCESS_TOKEN.equals(context.getTokenType()) && !OAuth2TokenFormat.SELF_CONTAINED.equals(context.getRegisteredClient().getTokenSettings().getAccessTokenFormat())) {
            return null;
        }
        String issuer = null;
        if (context.getAuthorizationServerContext() != null) {
            issuer = context.getAuthorizationServerContext().getIssuer();
        }
        RegisteredClient registeredClient = context.getRegisteredClient();
        Instant issuedAt = this.clock.instant();
        SignatureAlgorithm jwsAlgorithm = SignatureAlgorithm.RS256;
        if ("id_token".equals(context.getTokenType().getValue())) {
            expiresAt = issuedAt.plus(30L, ChronoUnit.MINUTES);
            if (registeredClient.getTokenSettings().getIdTokenSignatureAlgorithm() != null) {
                jwsAlgorithm = registeredClient.getTokenSettings().getIdTokenSignatureAlgorithm();
            }
        } else {
            expiresAt = issuedAt.plus(registeredClient.getTokenSettings().getAccessTokenTimeToLive());
        }
        JwtClaimsSet.Builder claimsBuilder = JwtClaimsSet.builder();
        if (StringUtils.hasText((String)issuer)) {
            claimsBuilder.issuer(issuer);
        }
        claimsBuilder.subject(context.getPrincipal().getName()).audience(Collections.singletonList(registeredClient.getClientId())).issuedAt(issuedAt).expiresAt(expiresAt).id(UUID.randomUUID().toString());
        if (OAuth2TokenType.ACCESS_TOKEN.equals(context.getTokenType())) {
            claimsBuilder.notBefore(issuedAt);
            if (!CollectionUtils.isEmpty(context.getAuthorizedScopes())) {
                claimsBuilder.claim("scope", context.getAuthorizedScopes());
            }
        } else if ("id_token".equals(context.getTokenType().getValue())) {
            claimsBuilder.claim("azp", (Object)registeredClient.getClientId());
            if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)context.getAuthorizationGrantType())) {
                OAuth2AuthorizationRequest authorizationRequest = (OAuth2AuthorizationRequest)context.getAuthorization().getAttribute(OAuth2AuthorizationRequest.class.getName());
                String nonce = (String)authorizationRequest.getAdditionalParameters().get("nonce");
                if (StringUtils.hasText((String)nonce)) {
                    claimsBuilder.claim("nonce", (Object)nonce);
                }
                if ((sessionInformation = context.get(SessionInformation.class)) != null) {
                    claimsBuilder.claim("sid", (Object)sessionInformation.getSessionId());
                    claimsBuilder.claim("auth_time", (Object)sessionInformation.getLastRequest());
                }
            } else if (AuthorizationGrantType.REFRESH_TOKEN.equals((Object)context.getAuthorizationGrantType())) {
                OidcIdToken currentIdToken = context.getAuthorization().getToken(OidcIdToken.class).getToken();
                if (currentIdToken.hasClaim("sid")) {
                    claimsBuilder.claim("sid", currentIdToken.getClaim("sid"));
                }
                if (currentIdToken.hasClaim("auth_time")) {
                    claimsBuilder.claim("auth_time", currentIdToken.getClaim("auth_time"));
                }
            }
        }
        JwsHeader.Builder jwsHeaderBuilder = JwsHeader.with((JwsAlgorithm)jwsAlgorithm);
        if (this.jwtCustomizer != null) {
            Jwt dPoPProofJwt;
            JwtEncodingContext.Builder jwtContextBuilder = (JwtEncodingContext.Builder)((JwtEncodingContext.Builder)((JwtEncodingContext.Builder)((JwtEncodingContext.Builder)((JwtEncodingContext.Builder)((JwtEncodingContext.Builder)JwtEncodingContext.with(jwsHeaderBuilder, claimsBuilder).registeredClient(context.getRegisteredClient())).principal((Authentication)context.getPrincipal())).authorizationServerContext(context.getAuthorizationServerContext())).authorizedScopes(context.getAuthorizedScopes())).tokenType(context.getTokenType())).authorizationGrantType(context.getAuthorizationGrantType());
            if (context.getAuthorization() != null) {
                jwtContextBuilder.authorization(context.getAuthorization());
            }
            if (context.getAuthorizationGrant() != null) {
                jwtContextBuilder.authorizationGrant((Authentication)context.getAuthorizationGrant());
            }
            if ("id_token".equals(context.getTokenType().getValue()) && (sessionInformation = context.get(SessionInformation.class)) != null) {
                jwtContextBuilder.put(SessionInformation.class, sessionInformation);
            }
            if (OAuth2TokenType.ACCESS_TOKEN.equals(context.getTokenType()) && (dPoPProofJwt = (Jwt)context.get(OAuth2TokenContext.DPOP_PROOF_KEY)) != null) {
                jwtContextBuilder.put(OAuth2TokenContext.DPOP_PROOF_KEY, dPoPProofJwt);
            }
            JwtEncodingContext jwtContext = jwtContextBuilder.build();
            this.jwtCustomizer.customize(jwtContext);
        }
        JwsHeader jwsHeader = jwsHeaderBuilder.build();
        JwtClaimsSet claims = claimsBuilder.build();
        Jwt jwt = this.jwtEncoder.encode(JwtEncoderParameters.from((JwsHeader)jwsHeader, (JwtClaimsSet)claims));
        return jwt;
    }

    public void setJwtCustomizer(OAuth2TokenCustomizer<JwtEncodingContext> jwtCustomizer) {
        Assert.notNull(jwtCustomizer, (String)"jwtCustomizer cannot be null");
        this.jwtCustomizer = jwtCustomizer;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }
}

