/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.jackson;

import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.server.authorization.jackson.JsonNodeUtils;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.exc.InvalidFormatException;

final class OAuth2AuthorizationRequestDeserializer
extends ValueDeserializer<OAuth2AuthorizationRequest> {
    OAuth2AuthorizationRequestDeserializer() {
    }

    public OAuth2AuthorizationRequest deserialize(JsonParser parser, DeserializationContext context) {
        JsonNode root = context.readTree(parser);
        return this.deserialize(parser, context, root);
    }

    private OAuth2AuthorizationRequest deserialize(JsonParser parser, DeserializationContext context, JsonNode root) {
        AuthorizationGrantType authorizationGrantType = OAuth2AuthorizationRequestDeserializer.convertAuthorizationGrantType(JsonNodeUtils.findObjectNode(root, "authorizationGrantType"));
        OAuth2AuthorizationRequest.Builder builder = this.getBuilder(parser, authorizationGrantType);
        builder.authorizationUri(JsonNodeUtils.findStringValue(root, "authorizationUri"));
        builder.clientId(JsonNodeUtils.findStringValue(root, "clientId"));
        builder.redirectUri(JsonNodeUtils.findStringValue(root, "redirectUri"));
        builder.scopes(JsonNodeUtils.findValue(root, "scopes", JsonNodeUtils.STRING_SET, context));
        builder.state(JsonNodeUtils.findStringValue(root, "state"));
        builder.additionalParameters(JsonNodeUtils.findValue(root, "additionalParameters", JsonNodeUtils.STRING_OBJECT_MAP, context));
        builder.authorizationRequestUri(JsonNodeUtils.findStringValue(root, "authorizationRequestUri"));
        builder.attributes(JsonNodeUtils.findValue(root, "attributes", JsonNodeUtils.STRING_OBJECT_MAP, context));
        return builder.build();
    }

    private OAuth2AuthorizationRequest.Builder getBuilder(JsonParser parser, AuthorizationGrantType authorizationGrantType) {
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)authorizationGrantType)) {
            return OAuth2AuthorizationRequest.authorizationCode();
        }
        throw new InvalidFormatException(parser, "Invalid authorizationGrantType", (Object)authorizationGrantType, AuthorizationGrantType.class);
    }

    private static AuthorizationGrantType convertAuthorizationGrantType(JsonNode jsonNode) {
        String value = JsonNodeUtils.findStringValue(jsonNode, "value");
        if (AuthorizationGrantType.AUTHORIZATION_CODE.getValue().equalsIgnoreCase(value)) {
            return AuthorizationGrantType.AUTHORIZATION_CODE;
        }
        return null;
    }
}

