/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.jwt.DPoPProofContext;
import org.springframework.security.oauth2.jwt.DPoPProofJwtDecoderFactory;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationGrantAuthenticationToken;
import org.springframework.util.StringUtils;

final class DPoPProofVerifier {
    private static final JwtDecoderFactory<DPoPProofContext> dPoPProofVerifierFactory = new DPoPProofJwtDecoderFactory();

    private DPoPProofVerifier() {
    }

    static Jwt verifyIfAvailable(OAuth2AuthorizationGrantAuthenticationToken authorizationGrantAuthentication) {
        Jwt dPoPProofJwt;
        String dPoPProof = (String)authorizationGrantAuthentication.getAdditionalParameters().get("dpop_proof");
        if (!StringUtils.hasText((String)dPoPProof)) {
            return null;
        }
        String method = (String)authorizationGrantAuthentication.getAdditionalParameters().get("dpop_method");
        String targetUri = (String)authorizationGrantAuthentication.getAdditionalParameters().get("dpop_target_uri");
        try {
            DPoPProofContext dPoPProofContext = DPoPProofContext.withDPoPProof((String)dPoPProof).method(method).targetUri(targetUri).build();
            JwtDecoder dPoPProofVerifier = dPoPProofVerifierFactory.createDecoder((Object)dPoPProofContext);
            dPoPProofJwt = dPoPProofVerifier.decode(dPoPProof);
        }
        catch (Exception ex) {
            throw new OAuth2AuthenticationException(new OAuth2Error("invalid_dpop_proof"), (Throwable)ex);
        }
        return dPoPProofJwt;
    }
}

