/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.settings;

import java.io.Serializable;
import org.springframework.security.oauth2.server.authorization.util.SpringAuthorizationServerVersion;
import org.springframework.util.Assert;

public final class OAuth2TokenFormat
implements Serializable {
    private static final long serialVersionUID = SpringAuthorizationServerVersion.SERIAL_VERSION_UID;
    public static final OAuth2TokenFormat SELF_CONTAINED = new OAuth2TokenFormat("self-contained");
    public static final OAuth2TokenFormat REFERENCE = new OAuth2TokenFormat("reference");
    private final String value;

    public OAuth2TokenFormat(String value) {
        Assert.hasText((String)value, (String)"value cannot be empty");
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2TokenFormat that = (OAuth2TokenFormat)obj;
        return this.getValue().equals(that.getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }
}

