/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2DeviceAuthorizationConsentAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class OAuth2DeviceAuthorizationConsentAuthenticationConverter
implements AuthenticationConverter {
    private static final String ERROR_URI = "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2";
    private static final Authentication ANONYMOUS_AUTHENTICATION = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ANONYMOUS"}));

    public Authentication convert(HttpServletRequest request) {
        String state;
        String userCode;
        Authentication principal;
        if (!"POST".equals(request.getMethod()) || request.getParameter("state") == null) {
            return null;
        }
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getFormParameters(request);
        String authorizationUri = request.getRequestURL().toString();
        String clientId = (String)parameters.getFirst((Object)"client_id");
        if (!StringUtils.hasText((String)clientId) || ((List)parameters.get((Object)"client_id")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "client_id", ERROR_URI);
        }
        if ((principal = SecurityContextHolder.getContext().getAuthentication()) == null) {
            principal = ANONYMOUS_AUTHENTICATION;
        }
        if (!OAuth2EndpointUtils.validateUserCode(userCode = (String)parameters.getFirst((Object)"user_code")) || ((List)parameters.get((Object)"user_code")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "user_code", ERROR_URI);
        }
        if (!StringUtils.hasText((String)(state = (String)parameters.getFirst((Object)"state"))) || ((List)parameters.get((Object)"state")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "state", ERROR_URI);
        }
        HashSet<String> scopes = null;
        if (parameters.containsKey((Object)"scope")) {
            scopes = new HashSet<String>((Collection)parameters.get((Object)"scope"));
        }
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        parameters.forEach((key, value) -> {
            if (!(key.equals("client_id") || key.equals("user_code") || key.equals("state") || key.equals("scope"))) {
                additionalParameters.put((String)key, value.size() == 1 ? value.get(0) : value.toArray(new String[0]));
            }
        });
        return new OAuth2DeviceAuthorizationConsentAuthenticationToken(authorizationUri, clientId, principal, OAuth2EndpointUtils.normalizeUserCode(userCode), state, scopes, additionalParameters);
    }
}

