/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class CodeVerifierAuthenticator {
    private static final OAuth2TokenType AUTHORIZATION_CODE_TOKEN_TYPE = new OAuth2TokenType("code");
    private final OAuth2AuthorizationService authorizationService;

    CodeVerifierAuthenticator(OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        this.authorizationService = authorizationService;
    }

    void authenticateRequired(OAuth2ClientAuthenticationToken clientAuthentication, RegisteredClient registeredClient) {
        if (!this.authenticate(clientAuthentication, registeredClient)) {
            CodeVerifierAuthenticator.throwInvalidGrant("code_verifier");
        }
    }

    void authenticateIfAvailable(OAuth2ClientAuthenticationToken clientAuthentication, RegisteredClient registeredClient) {
        this.authenticate(clientAuthentication, registeredClient);
    }

    private boolean authenticate(OAuth2ClientAuthenticationToken clientAuthentication, RegisteredClient registeredClient) {
        OAuth2AuthorizationRequest authorizationRequest;
        String codeChallenge;
        Map<String, Object> parameters = clientAuthentication.getAdditionalParameters();
        if (!CodeVerifierAuthenticator.authorizationCodeGrant(parameters)) {
            return false;
        }
        OAuth2Authorization authorization = this.authorizationService.findByToken((String)parameters.get("code"), AUTHORIZATION_CODE_TOKEN_TYPE);
        if (authorization == null) {
            CodeVerifierAuthenticator.throwInvalidGrant("code");
        }
        if (!StringUtils.hasText((String)(codeChallenge = (String)(authorizationRequest = (OAuth2AuthorizationRequest)authorization.getAttribute(OAuth2AuthorizationRequest.class.getName())).getAdditionalParameters().get("code_challenge")))) {
            if (registeredClient.getClientSettings().isRequireProofKey()) {
                CodeVerifierAuthenticator.throwInvalidGrant("code_challenge");
            } else {
                return false;
            }
        }
        String codeChallengeMethod = (String)authorizationRequest.getAdditionalParameters().get("code_challenge_method");
        String codeVerifier = (String)parameters.get("code_verifier");
        if (!CodeVerifierAuthenticator.codeVerifierValid(codeVerifier, codeChallenge, codeChallengeMethod)) {
            CodeVerifierAuthenticator.throwInvalidGrant("code_verifier");
        }
        return true;
    }

    private static boolean authorizationCodeGrant(Map<String, Object> parameters) {
        return AuthorizationGrantType.AUTHORIZATION_CODE.getValue().equals(parameters.get("grant_type")) && parameters.get("code") != null;
    }

    private static boolean codeVerifierValid(String codeVerifier, String codeChallenge, String codeChallengeMethod) {
        if (!StringUtils.hasText((String)codeVerifier)) {
            return false;
        }
        if (!StringUtils.hasText((String)codeChallengeMethod) || "plain".equals(codeChallengeMethod)) {
            return codeVerifier.equals(codeChallenge);
        }
        if ("S256".equals(codeChallengeMethod)) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] digest = md.digest(codeVerifier.getBytes(StandardCharsets.US_ASCII));
                String encodedVerifier = Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
                return encodedVerifier.equals(codeChallenge);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        throw new OAuth2AuthenticationException("server_error");
    }

    private static void throwInvalidGrant(String parameterName) {
        OAuth2Error error = new OAuth2Error("invalid_grant", "Client authentication failed: " + parameterName, null);
        throw new OAuth2AuthenticationException(error);
    }
}

