/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.factories.DefaultJWSSignerFactory;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.produce.JWSSignerFactory;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.oauth2.jwt.JoseHeader;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimsSet;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.JwtEncodingException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Deprecated
public final class NimbusJwsEncoder
implements JwtEncoder {
    private static final String ENCODING_ERROR_MESSAGE_TEMPLATE = "An error occurred while attempting to encode the Jwt: %s";
    private static final Converter<JoseHeader, JWSHeader> JWS_HEADER_CONVERTER = new JwsHeaderConverter();
    private static final Converter<JwtClaimsSet, JWTClaimsSet> JWT_CLAIMS_SET_CONVERTER = new JwtClaimsSetConverter();
    private static final JWSSignerFactory JWS_SIGNER_FACTORY = new DefaultJWSSignerFactory();
    private final Map<JWK, JWSSigner> jwsSigners = new ConcurrentHashMap<JWK, JWSSigner>();
    private final JWKSource<SecurityContext> jwkSource;

    public NimbusJwsEncoder(JWKSource<SecurityContext> jwkSource) {
        Assert.notNull(jwkSource, (String)"jwkSource cannot be null");
        this.jwkSource = jwkSource;
    }

    @Override
    public Jwt encode(JoseHeader headers, JwtClaimsSet claims) throws JwtEncodingException {
        Assert.notNull((Object)headers, (String)"headers cannot be null");
        Assert.notNull((Object)claims, (String)"claims cannot be null");
        JWK jwk = this.selectJwk(headers);
        headers = NimbusJwsEncoder.addKeyIdentifierHeadersIfNecessary(headers, jwk);
        String jws = this.serialize(headers, claims, jwk);
        return new Jwt(jws, claims.getIssuedAt(), claims.getExpiresAt(), headers.getHeaders(), claims.getClaims());
    }

    private JWK selectJwk(JoseHeader headers) {
        List jwks;
        try {
            JWKSelector jwkSelector = new JWKSelector(NimbusJwsEncoder.createJwkMatcher(headers));
            jwks = this.jwkSource.get(jwkSelector, null);
        }
        catch (Exception ex) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to select a JWK signing key -> " + ex.getMessage()), ex);
        }
        if (jwks.size() > 1) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Found multiple JWK signing keys for algorithm '" + headers.getAlgorithm().getName() + "'"));
        }
        if (jwks.isEmpty()) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to select a JWK signing key"));
        }
        return (JWK)jwks.get(0);
    }

    private String serialize(JoseHeader headers, JwtClaimsSet claims, JWK jwk) {
        JWSHeader jwsHeader = (JWSHeader)JWS_HEADER_CONVERTER.convert((Object)headers);
        JWTClaimsSet jwtClaimsSet = (JWTClaimsSet)JWT_CLAIMS_SET_CONVERTER.convert((Object)claims);
        JWSSigner jwsSigner = this.jwsSigners.computeIfAbsent(jwk, NimbusJwsEncoder::createSigner);
        SignedJWT signedJwt = new SignedJWT(jwsHeader, jwtClaimsSet);
        try {
            signedJwt.sign(jwsSigner);
        }
        catch (JOSEException ex) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to sign the JWT -> " + ex.getMessage()), ex);
        }
        return signedJwt.serialize();
    }

    private static JWKMatcher createJwkMatcher(JoseHeader headers) {
        JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)headers.getAlgorithm().getName());
        if (JWSAlgorithm.Family.RSA.contains((Object)jwsAlgorithm) || JWSAlgorithm.Family.EC.contains((Object)jwsAlgorithm)) {
            return new JWKMatcher.Builder().keyType(KeyType.forAlgorithm((Algorithm)jwsAlgorithm)).keyID(headers.getKeyId()).keyUses(new KeyUse[]{KeyUse.SIGNATURE, null}).algorithms(new Algorithm[]{jwsAlgorithm, null}).x509CertSHA256Thumbprint(Base64URL.from((String)headers.getX509SHA256Thumbprint())).build();
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)jwsAlgorithm)) {
            return new JWKMatcher.Builder().keyType(KeyType.forAlgorithm((Algorithm)jwsAlgorithm)).keyID(headers.getKeyId()).privateOnly(true).algorithms(new Algorithm[]{jwsAlgorithm, null}).build();
        }
        return null;
    }

    private static JoseHeader addKeyIdentifierHeadersIfNecessary(JoseHeader headers, JWK jwk) {
        if (StringUtils.hasText((String)headers.getKeyId()) && StringUtils.hasText((String)headers.getX509SHA256Thumbprint())) {
            return headers;
        }
        if (!StringUtils.hasText((String)jwk.getKeyID()) && jwk.getX509CertSHA256Thumbprint() == null) {
            return headers;
        }
        JoseHeader.Builder headersBuilder = JoseHeader.from(headers);
        if (!StringUtils.hasText((String)headers.getKeyId()) && StringUtils.hasText((String)jwk.getKeyID())) {
            headersBuilder.keyId(jwk.getKeyID());
        }
        if (!StringUtils.hasText((String)headers.getX509SHA256Thumbprint()) && jwk.getX509CertSHA256Thumbprint() != null) {
            headersBuilder.x509SHA256Thumbprint(jwk.getX509CertSHA256Thumbprint().toString());
        }
        return headersBuilder.build();
    }

    private static JWSSigner createSigner(JWK jwk) {
        try {
            return JWS_SIGNER_FACTORY.createJWSSigner(jwk);
        }
        catch (JOSEException ex) {
            throw new JwtEncodingException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to create a JWS Signer -> " + ex.getMessage()), ex);
        }
    }

    private static class JwtClaimsSetConverter
    implements Converter<JwtClaimsSet, JWTClaimsSet> {
        private JwtClaimsSetConverter() {
        }

        public JWTClaimsSet convert(JwtClaimsSet claims) {
            String jwtId;
            Instant issuedAt;
            Instant notBefore;
            Instant expiresAt;
            List audience;
            String subject;
            JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
            Object issuer = claims.getClaim("iss");
            if (issuer != null) {
                builder.issuer(issuer.toString());
            }
            if (StringUtils.hasText((String)(subject = claims.getSubject()))) {
                builder.subject(subject);
            }
            if (!CollectionUtils.isEmpty((Collection)(audience = claims.getAudience()))) {
                builder.audience(audience);
            }
            if ((expiresAt = claims.getExpiresAt()) != null) {
                builder.expirationTime(Date.from(expiresAt));
            }
            if ((notBefore = claims.getNotBefore()) != null) {
                builder.notBeforeTime(Date.from(notBefore));
            }
            if ((issuedAt = claims.getIssuedAt()) != null) {
                builder.issueTime(Date.from(issuedAt));
            }
            if (StringUtils.hasText((String)(jwtId = claims.getId()))) {
                builder.jwtID(jwtId);
            }
            HashMap<String, Object> customClaims = new HashMap<String, Object>();
            claims.getClaims().forEach((name, value) -> {
                if (!JWTClaimsSet.getRegisteredNames().contains(name)) {
                    customClaims.put((String)name, value);
                }
            });
            if (!customClaims.isEmpty()) {
                customClaims.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)builder).claim(arg_0, arg_1));
            }
            return builder.build();
        }
    }

    private static class JwsHeaderConverter
    implements Converter<JoseHeader, JWSHeader> {
        private JwsHeaderConverter() {
        }

        public JWSHeader convert(JoseHeader headers) {
            Set<String> critical;
            String contentType;
            String type;
            String x509SHA256Thumbprint;
            String x509SHA1Thumbprint;
            List<String> x509CertificateChain;
            String keyId;
            Map<String, Object> jwk;
            JWSHeader.Builder builder = new JWSHeader.Builder(JWSAlgorithm.parse((String)headers.getAlgorithm().getName()));
            if (headers.getJwkSetUrl() != null) {
                builder.jwkURL(JwsHeaderConverter.convertAsURI("jku", headers.getJwkSetUrl()));
            }
            if (!CollectionUtils.isEmpty(jwk = headers.getJwk())) {
                try {
                    builder.jwk(JWK.parse(jwk));
                }
                catch (Exception ex) {
                    throw new JwtEncodingException(String.format(NimbusJwsEncoder.ENCODING_ERROR_MESSAGE_TEMPLATE, "Unable to convert 'jwk' JOSE header"), ex);
                }
            }
            if (StringUtils.hasText((String)(keyId = headers.getKeyId()))) {
                builder.keyID(keyId);
            }
            if (headers.getX509Url() != null) {
                builder.x509CertURL(JwsHeaderConverter.convertAsURI("x5u", headers.getX509Url()));
            }
            if (!CollectionUtils.isEmpty(x509CertificateChain = headers.getX509CertificateChain())) {
                ArrayList x5cList = new ArrayList();
                x509CertificateChain.forEach(x5c -> x5cList.add(new Base64(x5c)));
                if (!x5cList.isEmpty()) {
                    builder.x509CertChain(x5cList);
                }
            }
            if (StringUtils.hasText((String)(x509SHA1Thumbprint = headers.getX509SHA1Thumbprint()))) {
                builder.x509CertThumbprint(new Base64URL(x509SHA1Thumbprint));
            }
            if (StringUtils.hasText((String)(x509SHA256Thumbprint = headers.getX509SHA256Thumbprint()))) {
                builder.x509CertSHA256Thumbprint(new Base64URL(x509SHA256Thumbprint));
            }
            if (StringUtils.hasText((String)(type = headers.getType()))) {
                builder.type(new JOSEObjectType(type));
            }
            if (StringUtils.hasText((String)(contentType = headers.getContentType()))) {
                builder.contentType(contentType);
            }
            if (!CollectionUtils.isEmpty(critical = headers.getCritical())) {
                builder.criticalParams(critical);
            }
            HashMap customHeaders = new HashMap();
            headers.getHeaders().forEach((name, value) -> {
                if (!JWSHeader.getRegisteredParameterNames().contains(name)) {
                    customHeaders.put(name, value);
                }
            });
            if (!customHeaders.isEmpty()) {
                builder.customParams(customHeaders);
            }
            return builder.build();
        }

        private static URI convertAsURI(String header, URL url) {
            try {
                return url.toURI();
            }
            catch (Exception ex) {
                throw new JwtEncodingException(String.format(NimbusJwsEncoder.ENCODING_ERROR_MESSAGE_TEMPLATE, "Unable to convert '" + header + "' JOSE header to a URI"), ex);
            }
        }
    }
}

