/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.security.oauth2.core.converter.ClaimConversionService;
import org.springframework.security.oauth2.jose.JwaAlgorithm;
import org.springframework.util.Assert;

@Deprecated
public final class JoseHeader {
    private final Map<String, Object> headers;

    private JoseHeader(Map<String, Object> headers) {
        this.headers = Collections.unmodifiableMap(new HashMap<String, Object>(headers));
    }

    public <T extends JwaAlgorithm> T getAlgorithm() {
        return (T)((JwaAlgorithm)this.getHeader("alg"));
    }

    public URL getJwkSetUrl() {
        return (URL)this.getHeader("jku");
    }

    public Map<String, Object> getJwk() {
        return (Map)this.getHeader("jwk");
    }

    public String getKeyId() {
        return (String)this.getHeader("kid");
    }

    public URL getX509Url() {
        return (URL)this.getHeader("x5u");
    }

    public List<String> getX509CertificateChain() {
        return (List)this.getHeader("x5c");
    }

    public String getX509SHA1Thumbprint() {
        return (String)this.getHeader("x5t");
    }

    public String getX509SHA256Thumbprint() {
        return (String)this.getHeader("x5t#S256");
    }

    public String getType() {
        return (String)this.getHeader("typ");
    }

    public String getContentType() {
        return (String)this.getHeader("cty");
    }

    public Set<String> getCritical() {
        return (Set)this.getHeader("crit");
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public <T> T getHeader(String name) {
        Assert.hasText((String)name, (String)"name cannot be empty");
        return (T)this.getHeaders().get(name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder withAlgorithm(JwaAlgorithm jwaAlgorithm) {
        return new Builder(jwaAlgorithm);
    }

    public static Builder from(JoseHeader headers) {
        return new Builder(headers);
    }

    public static final class Builder {
        private final Map<String, Object> headers = new HashMap<String, Object>();

        private Builder() {
        }

        private Builder(JwaAlgorithm jwaAlgorithm) {
            this.algorithm(jwaAlgorithm);
        }

        private Builder(JoseHeader headers) {
            Assert.notNull((Object)headers, (String)"headers cannot be null");
            this.headers.putAll(headers.getHeaders());
        }

        public Builder algorithm(JwaAlgorithm jwaAlgorithm) {
            Assert.notNull((Object)jwaAlgorithm, (String)"jwaAlgorithm cannot be null");
            return this.header("alg", jwaAlgorithm);
        }

        public Builder jwkSetUrl(String jwkSetUrl) {
            return this.header("jku", Builder.convertAsURL("jku", jwkSetUrl));
        }

        public Builder jwk(Map<String, Object> jwk) {
            return this.header("jwk", jwk);
        }

        public Builder keyId(String keyId) {
            return this.header("kid", keyId);
        }

        public Builder x509Url(String x509Url) {
            return this.header("x5u", Builder.convertAsURL("x5u", x509Url));
        }

        public Builder x509CertificateChain(List<String> x509CertificateChain) {
            return this.header("x5c", x509CertificateChain);
        }

        public Builder x509SHA1Thumbprint(String x509SHA1Thumbprint) {
            return this.header("x5t", x509SHA1Thumbprint);
        }

        public Builder x509SHA256Thumbprint(String x509SHA256Thumbprint) {
            return this.header("x5t#S256", x509SHA256Thumbprint);
        }

        public Builder type(String type) {
            return this.header("typ", type);
        }

        public Builder contentType(String contentType) {
            return this.header("cty", contentType);
        }

        public Builder critical(Set<String> headerNames) {
            return this.header("crit", headerNames);
        }

        public Builder header(String name, Object value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.headers.put(name, value);
            return this;
        }

        public Builder headers(Consumer<Map<String, Object>> headersConsumer) {
            headersConsumer.accept(this.headers);
            return this;
        }

        public JoseHeader build() {
            Assert.notEmpty(this.headers, (String)"headers cannot be empty");
            return new JoseHeader(this.headers);
        }

        private static URL convertAsURL(String header, String value) {
            URL convertedValue = (URL)ClaimConversionService.getSharedInstance().convert((Object)value, URL.class);
            Assert.isTrue((convertedValue != null ? 1 : 0) != 0, () -> "Unable to convert header '" + header + "' of type '" + value.getClass() + "' to URL.");
            return convertedValue;
        }
    }
}

