/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.context.Context;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class OAuth2AuthenticationContext
implements Context {
    private final Map<Object, Object> context;

    public OAuth2AuthenticationContext(Authentication authentication, @Nullable Map<Object, Object> context) {
        Assert.notNull((Object)authentication, (String)"authentication cannot be null");
        HashMap<Object, Object> ctx = new HashMap<Object, Object>();
        if (!CollectionUtils.isEmpty(context)) {
            ctx.putAll(context);
        }
        ctx.put(Authentication.class, authentication);
        this.context = Collections.unmodifiableMap(ctx);
    }

    public OAuth2AuthenticationContext(Map<Object, Object> context) {
        Assert.notEmpty(context, (String)"context cannot be empty");
        Assert.notNull((Object)context.get(Authentication.class), (String)"authentication cannot be null");
        this.context = Collections.unmodifiableMap(new HashMap<Object, Object>(context));
    }

    public <T extends Authentication> T getAuthentication() {
        return (T)this.get(Authentication.class);
    }

    @Override
    @Nullable
    public <V> V get(Object key) {
        return (V)(this.hasKey(key) ? this.context.get(key) : null);
    }

    @Override
    public boolean hasKey(Object key) {
        Assert.notNull((Object)key, (String)"key cannot be null");
        return this.context.containsKey(key);
    }

    protected static abstract class AbstractBuilder<T extends OAuth2AuthenticationContext, B extends AbstractBuilder<T, B>> {
        private final Map<Object, Object> context = new HashMap<Object, Object>();

        protected AbstractBuilder(Authentication authentication) {
            Assert.notNull((Object)authentication, (String)"authentication cannot be null");
            this.put(Authentication.class, authentication);
        }

        public B put(Object key, Object value) {
            Assert.notNull((Object)key, (String)"key cannot be null");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.getContext().put(key, value);
            return this.getThis();
        }

        public B context(Consumer<Map<Object, Object>> contextConsumer) {
            contextConsumer.accept(this.getContext());
            return this.getThis();
        }

        protected <V> V get(Object key) {
            return (V)this.getContext().get(key);
        }

        protected Map<Object, Object> getContext() {
            return this.context;
        }

        protected final B getThis() {
            return (B)this;
        }

        public abstract T build();
    }
}

