/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.AbstractOAuth2Configurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2ConfigurerUtils;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OidcClientRegistrationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OidcUserInfoEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.oauth2.server.authorization.oidc.web.OidcProviderConfigurationEndpointFilter;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class OidcConfigurer
extends AbstractOAuth2Configurer {
    private final Map<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> configurers = new LinkedHashMap<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer>();
    private RequestMatcher requestMatcher;

    OidcConfigurer(ObjectPostProcessor<Object> objectPostProcessor) {
        super(objectPostProcessor);
        this.addConfigurer(OidcUserInfoEndpointConfigurer.class, new OidcUserInfoEndpointConfigurer(objectPostProcessor));
    }

    public OidcConfigurer clientRegistrationEndpoint(Customizer<OidcClientRegistrationEndpointConfigurer> clientRegistrationEndpointCustomizer) {
        OidcClientRegistrationEndpointConfigurer clientRegistrationEndpointConfigurer = this.getConfigurer(OidcClientRegistrationEndpointConfigurer.class);
        if (clientRegistrationEndpointConfigurer == null) {
            this.addConfigurer(OidcClientRegistrationEndpointConfigurer.class, new OidcClientRegistrationEndpointConfigurer(this.getObjectPostProcessor()));
            clientRegistrationEndpointConfigurer = this.getConfigurer(OidcClientRegistrationEndpointConfigurer.class);
        }
        clientRegistrationEndpointCustomizer.customize((Object)clientRegistrationEndpointConfigurer);
        return this;
    }

    public OidcConfigurer userInfoEndpoint(Customizer<OidcUserInfoEndpointConfigurer> userInfoEndpointCustomizer) {
        userInfoEndpointCustomizer.customize((Object)this.getConfigurer(OidcUserInfoEndpointConfigurer.class));
        return this;
    }

    @Override
    <B extends HttpSecurityBuilder<B>> void init(B builder) {
        OidcUserInfoEndpointConfigurer userInfoEndpointConfigurer = this.getConfigurer(OidcUserInfoEndpointConfigurer.class);
        userInfoEndpointConfigurer.init(builder);
        OidcClientRegistrationEndpointConfigurer clientRegistrationEndpointConfigurer = this.getConfigurer(OidcClientRegistrationEndpointConfigurer.class);
        if (clientRegistrationEndpointConfigurer != null) {
            clientRegistrationEndpointConfigurer.init(builder);
        }
        ArrayList<Object> requestMatchers = new ArrayList<Object>();
        requestMatchers.add(new AntPathRequestMatcher("/.well-known/openid-configuration", HttpMethod.GET.name()));
        requestMatchers.add(userInfoEndpointConfigurer.getRequestMatcher());
        if (clientRegistrationEndpointConfigurer != null) {
            requestMatchers.add(clientRegistrationEndpointConfigurer.getRequestMatcher());
        }
        this.requestMatcher = new OrRequestMatcher(requestMatchers);
    }

    @Override
    <B extends HttpSecurityBuilder<B>> void configure(B builder) {
        OidcUserInfoEndpointConfigurer userInfoEndpointConfigurer = this.getConfigurer(OidcUserInfoEndpointConfigurer.class);
        userInfoEndpointConfigurer.configure(builder);
        OidcClientRegistrationEndpointConfigurer clientRegistrationEndpointConfigurer = this.getConfigurer(OidcClientRegistrationEndpointConfigurer.class);
        if (clientRegistrationEndpointConfigurer != null) {
            clientRegistrationEndpointConfigurer.configure(builder);
        }
        ProviderSettings providerSettings = OAuth2ConfigurerUtils.getProviderSettings(builder);
        OidcProviderConfigurationEndpointFilter oidcProviderConfigurationEndpointFilter = new OidcProviderConfigurationEndpointFilter(providerSettings);
        builder.addFilterBefore((Filter)this.postProcess(oidcProviderConfigurationEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
    }

    @Override
    RequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }

    <T> T getConfigurer(Class<T> type) {
        return (T)this.configurers.get(type);
    }

    private <T extends AbstractOAuth2Configurer> void addConfigurer(Class<T> configurerType, T configurer) {
        this.configurers.put(configurerType, configurer);
    }
}

