/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.Filter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.AbstractOAuth2Configurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2AuthorizationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2ClientAuthenticationConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2ConfigurerUtils;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2TokenEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2TokenIntrospectionEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2TokenRevocationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OidcClientRegistrationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OidcConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OidcUserInfoEndpointConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.Transient;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.security.oauth2.server.authorization.web.NimbusJwkSetEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.OAuth2AuthorizationServerMetadataEndpointFilter;
import org.springframework.security.oauth2.server.authorization.web.ProviderContextFilter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SaveContextOnUpdateOrErrorResponseWrapper;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class OAuth2AuthorizationServerConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<OAuth2AuthorizationServerConfigurer<B>, B> {
    private final Map<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> configurers = this.createConfigurers();
    private RequestMatcher jwkSetEndpointMatcher;
    private RequestMatcher authorizationServerMetadataEndpointMatcher;
    private final RequestMatcher endpointsMatcher = request -> this.getRequestMatcher(OAuth2AuthorizationEndpointConfigurer.class).matches(request) || this.getRequestMatcher(OAuth2TokenEndpointConfigurer.class).matches(request) || this.getRequestMatcher(OAuth2TokenIntrospectionEndpointConfigurer.class).matches(request) || this.getRequestMatcher(OAuth2TokenRevocationEndpointConfigurer.class).matches(request) || this.getRequestMatcher(OidcConfigurer.class).matches(request) || this.jwkSetEndpointMatcher.matches(request) || this.authorizationServerMetadataEndpointMatcher.matches(request);

    public OAuth2AuthorizationServerConfigurer<B> registeredClientRepository(RegisteredClientRepository registeredClientRepository) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(RegisteredClientRepository.class, (Object)registeredClientRepository);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> authorizationService(OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(OAuth2AuthorizationService.class, (Object)authorizationService);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> authorizationConsentService(OAuth2AuthorizationConsentService authorizationConsentService) {
        Assert.notNull((Object)authorizationConsentService, (String)"authorizationConsentService cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(OAuth2AuthorizationConsentService.class, (Object)authorizationConsentService);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> providerSettings(ProviderSettings providerSettings) {
        Assert.notNull((Object)providerSettings, (String)"providerSettings cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ProviderSettings.class, (Object)providerSettings);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> tokenGenerator(OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator) {
        Assert.notNull(tokenGenerator, (String)"tokenGenerator cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(OAuth2TokenGenerator.class, tokenGenerator);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> clientAuthentication(Customizer<OAuth2ClientAuthenticationConfigurer> clientAuthenticationCustomizer) {
        clientAuthenticationCustomizer.customize((Object)this.getConfigurer(OAuth2ClientAuthenticationConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> authorizationEndpoint(Customizer<OAuth2AuthorizationEndpointConfigurer> authorizationEndpointCustomizer) {
        authorizationEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2AuthorizationEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> tokenEndpoint(Customizer<OAuth2TokenEndpointConfigurer> tokenEndpointCustomizer) {
        tokenEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2TokenEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> tokenIntrospectionEndpoint(Customizer<OAuth2TokenIntrospectionEndpointConfigurer> tokenIntrospectionEndpointCustomizer) {
        tokenIntrospectionEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2TokenIntrospectionEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> tokenRevocationEndpoint(Customizer<OAuth2TokenRevocationEndpointConfigurer> tokenRevocationEndpointCustomizer) {
        tokenRevocationEndpointCustomizer.customize((Object)this.getConfigurer(OAuth2TokenRevocationEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer<B> oidc(Customizer<OidcConfigurer> oidcCustomizer) {
        oidcCustomizer.customize((Object)this.getConfigurer(OidcConfigurer.class));
        return this;
    }

    public RequestMatcher getEndpointsMatcher() {
        return this.endpointsMatcher;
    }

    public void init(B builder) {
        ProviderSettings providerSettings = OAuth2ConfigurerUtils.getProviderSettings(builder);
        OAuth2AuthorizationServerConfigurer.validateProviderSettings(providerSettings);
        this.initEndpointMatchers(providerSettings);
        this.configurers.values().forEach(configurer -> configurer.init(builder));
        ExceptionHandlingConfigurer exceptionHandling = (ExceptionHandlingConfigurer)builder.getConfigurer(ExceptionHandlingConfigurer.class);
        if (exceptionHandling != null) {
            exceptionHandling.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED), (RequestMatcher)new OrRequestMatcher(new RequestMatcher[]{this.getRequestMatcher(OAuth2TokenEndpointConfigurer.class), this.getRequestMatcher(OAuth2TokenIntrospectionEndpointConfigurer.class), this.getRequestMatcher(OAuth2TokenRevocationEndpointConfigurer.class)}));
        }
        this.initSecurityContextRepository(builder);
    }

    private void initSecurityContextRepository(B builder) {
        final SecurityContextRepository securityContextRepository = (SecurityContextRepository)builder.getSharedObject(SecurityContextRepository.class);
        if (!(securityContextRepository instanceof HttpSessionSecurityContextRepository)) {
            return;
        }
        SecurityContextRepository securityContextRepositoryTransientNotSaved = new SecurityContextRepository(){
            private final RequestMatcher clientAuthenticationRequestMatcher = this.initClientAuthenticationRequestMatcher();
            private final RequestMatcher jwtAuthenticationRequestMatcher = this.initJwtAuthenticationRequestMatcher();

            public org.springframework.security.core.context.SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
                HttpServletRequest unwrappedRequest = requestResponseHolder.getRequest();
                HttpServletResponse unwrappedResponse = requestResponseHolder.getResponse();
                org.springframework.security.core.context.SecurityContext securityContext = securityContextRepository.loadContext(requestResponseHolder);
                if (this.clientAuthenticationRequestMatcher.matches(unwrappedRequest) || this.jwtAuthenticationRequestMatcher.matches(unwrappedRequest)) {
                    final SaveContextOnUpdateOrErrorResponseWrapper transientAuthenticationResponseWrapper = new SaveContextOnUpdateOrErrorResponseWrapper(unwrappedResponse, false){

                        protected void saveContext(org.springframework.security.core.context.SecurityContext context) {
                            if (context.getAuthentication() != null) {
                                Assert.state((boolean)this.isTransientAuthentication(context.getAuthentication()), (String)"Expected @Transient Authentication");
                            }
                        }
                    };
                    requestResponseHolder.setResponse((HttpServletResponse)transientAuthenticationResponseWrapper);
                    HttpServletRequestWrapper transientAuthenticationRequestWrapper = new HttpServletRequestWrapper(unwrappedRequest){

                        public AsyncContext startAsync() {
                            transientAuthenticationResponseWrapper.disableSaveOnResponseCommitted();
                            return super.startAsync();
                        }

                        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
                            transientAuthenticationResponseWrapper.disableSaveOnResponseCommitted();
                            return super.startAsync(servletRequest, servletResponse);
                        }
                    };
                    requestResponseHolder.setRequest((HttpServletRequest)transientAuthenticationRequestWrapper);
                }
                return securityContext;
            }

            public void saveContext(org.springframework.security.core.context.SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
                Authentication authentication = context.getAuthentication();
                if (authentication == null || this.isTransientAuthentication(authentication)) {
                    return;
                }
                securityContextRepository.saveContext(context, request, response);
            }

            public boolean containsContext(HttpServletRequest request) {
                return securityContextRepository.containsContext(request);
            }

            private boolean isTransientAuthentication(Authentication authentication) {
                return AnnotationUtils.getAnnotation(authentication.getClass(), Transient.class) != null;
            }

            private RequestMatcher initClientAuthenticationRequestMatcher() {
                ArrayList<RequestMatcher> requestMatchers = new ArrayList<RequestMatcher>();
                requestMatchers.add(OAuth2AuthorizationServerConfigurer.this.getRequestMatcher(OAuth2TokenEndpointConfigurer.class));
                requestMatchers.add(OAuth2AuthorizationServerConfigurer.this.getRequestMatcher(OAuth2TokenIntrospectionEndpointConfigurer.class));
                requestMatchers.add(OAuth2AuthorizationServerConfigurer.this.getRequestMatcher(OAuth2TokenRevocationEndpointConfigurer.class));
                return new OrRequestMatcher(requestMatchers);
            }

            private RequestMatcher initJwtAuthenticationRequestMatcher() {
                ArrayList<RequestMatcher> requestMatchers = new ArrayList<RequestMatcher>();
                requestMatchers.add(((OidcConfigurer)OAuth2AuthorizationServerConfigurer.this.getConfigurer(OidcConfigurer.class)).getConfigurer(OidcUserInfoEndpointConfigurer.class).getRequestMatcher());
                OidcClientRegistrationEndpointConfigurer clientRegistrationEndpointConfigurer = ((OidcConfigurer)OAuth2AuthorizationServerConfigurer.this.getConfigurer(OidcConfigurer.class)).getConfigurer(OidcClientRegistrationEndpointConfigurer.class);
                if (clientRegistrationEndpointConfigurer != null) {
                    requestMatchers.add(clientRegistrationEndpointConfigurer.getRequestMatcher());
                }
                return new OrRequestMatcher(requestMatchers);
            }
        };
        builder.setSharedObject(SecurityContextRepository.class, (Object)securityContextRepositoryTransientNotSaved);
    }

    public void configure(B builder) {
        this.configurers.values().forEach(configurer -> configurer.configure(builder));
        ProviderSettings providerSettings = OAuth2ConfigurerUtils.getProviderSettings(builder);
        ProviderContextFilter providerContextFilter = new ProviderContextFilter(providerSettings);
        builder.addFilterAfter((Filter)this.postProcess((Object)providerContextFilter), SecurityContextPersistenceFilter.class);
        JWKSource<SecurityContext> jwkSource = OAuth2ConfigurerUtils.getJwkSource(builder);
        if (jwkSource != null) {
            NimbusJwkSetEndpointFilter jwkSetEndpointFilter = new NimbusJwkSetEndpointFilter(jwkSource, providerSettings.getJwkSetEndpoint());
            builder.addFilterBefore((Filter)this.postProcess((Object)jwkSetEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
        }
        OAuth2AuthorizationServerMetadataEndpointFilter authorizationServerMetadataEndpointFilter = new OAuth2AuthorizationServerMetadataEndpointFilter(providerSettings);
        builder.addFilterBefore((Filter)this.postProcess((Object)authorizationServerMetadataEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
    }

    private Map<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> createConfigurers() {
        LinkedHashMap<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> configurers = new LinkedHashMap<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer>();
        configurers.put(OAuth2ClientAuthenticationConfigurer.class, new OAuth2ClientAuthenticationConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)arg_0 -> ((OAuth2AuthorizationServerConfigurer)this).postProcess(arg_0))));
        configurers.put(OAuth2AuthorizationEndpointConfigurer.class, new OAuth2AuthorizationEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)arg_0 -> ((OAuth2AuthorizationServerConfigurer)this).postProcess(arg_0))));
        configurers.put(OAuth2TokenEndpointConfigurer.class, new OAuth2TokenEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)arg_0 -> ((OAuth2AuthorizationServerConfigurer)this).postProcess(arg_0))));
        configurers.put(OAuth2TokenIntrospectionEndpointConfigurer.class, new OAuth2TokenIntrospectionEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)arg_0 -> ((OAuth2AuthorizationServerConfigurer)this).postProcess(arg_0))));
        configurers.put(OAuth2TokenRevocationEndpointConfigurer.class, new OAuth2TokenRevocationEndpointConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)arg_0 -> ((OAuth2AuthorizationServerConfigurer)this).postProcess(arg_0))));
        configurers.put(OidcConfigurer.class, new OidcConfigurer((ObjectPostProcessor<Object>)((ObjectPostProcessor)arg_0 -> ((OAuth2AuthorizationServerConfigurer)this).postProcess(arg_0))));
        return configurers;
    }

    private <T> T getConfigurer(Class<T> type) {
        return (T)this.configurers.get(type);
    }

    private <T extends AbstractOAuth2Configurer> RequestMatcher getRequestMatcher(Class<T> configurerType) {
        return ((AbstractOAuth2Configurer)this.getConfigurer(configurerType)).getRequestMatcher();
    }

    private void initEndpointMatchers(ProviderSettings providerSettings) {
        this.jwkSetEndpointMatcher = new AntPathRequestMatcher(providerSettings.getJwkSetEndpoint(), HttpMethod.GET.name());
        this.authorizationServerMetadataEndpointMatcher = new AntPathRequestMatcher("/.well-known/oauth-authorization-server", HttpMethod.GET.name());
    }

    private static void validateProviderSettings(ProviderSettings providerSettings) {
        if (providerSettings.getIssuer() != null) {
            try {
                new URI(providerSettings.getIssuer()).toURL();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("issuer must be a valid URL", ex);
            }
        }
    }
}

