/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DelegatingDeserializer
implements Deserializer<Object> {
    private final Map<String, Deserializer<?>> delegates = new ConcurrentHashMap();
    private final Map<String, Object> autoConfigs = new HashMap<String, Object>();
    private boolean forKeys;

    public DelegatingDeserializer() {
    }

    public DelegatingDeserializer(Map<String, Deserializer<?>> delegates) {
        this.delegates.putAll(delegates);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.autoConfigs.putAll(configs);
        this.forKeys = isKey;
        String configKey = this.configKey();
        Object value = configs.get(configKey);
        if (value == null) {
            return;
        }
        if (value instanceof Map) {
            ((Map)value).forEach((selector, deser) -> {
                if (deser instanceof Deserializer) {
                    Deserializer clazz = (Deserializer)deser;
                    this.delegates.put((String)selector, (Deserializer<?>)clazz);
                    clazz.configure(configs, isKey);
                } else if (deser instanceof Class) {
                    Class clazz = (Class)deser;
                    DelegatingDeserializer.instantiateAndConfigure(configs, isKey, this.delegates, selector, clazz);
                } else if (deser instanceof String) {
                    String className = (String)deser;
                    DelegatingDeserializer.createInstanceAndConfigure(configs, isKey, this.delegates, selector, className);
                } else {
                    throw new IllegalStateException(configKey + " map entries must be Serializers or class names, not " + String.valueOf(value.getClass()));
                }
            });
        } else if (value instanceof String) {
            String mappings = (String)value;
            this.delegates.putAll(DelegatingDeserializer.createDelegates(mappings, configs, isKey));
        } else {
            throw new IllegalStateException(configKey + " must be a map or String, not " + String.valueOf(value.getClass()));
        }
    }

    private String configKey() {
        return this.forKeys ? "spring.kafka.key.serialization.selector.config" : "spring.kafka.serialization.selector.config";
    }

    protected static Map<String, Deserializer<?>> createDelegates(String mappings, Map<String, ?> configs, boolean isKey) {
        String[] array;
        HashMap delegateMap = new HashMap();
        for (String entry : array = StringUtils.commaDelimitedListToStringArray((String)mappings)) {
            String[] split = entry.split(":");
            Assert.isTrue((split.length == 2 ? 1 : 0) != 0, (String)"Each comma-delimited selector entry must have exactly one ':'");
            DelegatingDeserializer.createInstanceAndConfigure(configs, isKey, delegateMap, split[0], split[1]);
        }
        return delegateMap;
    }

    protected static void createInstanceAndConfigure(Map<String, ?> configs, boolean isKey, Map<String, Deserializer<?>> delegateMap, String selector, String className) {
        try {
            Class clazz = ClassUtils.forName((String)className.trim(), (ClassLoader)ClassUtils.getDefaultClassLoader());
            DelegatingDeserializer.instantiateAndConfigure(configs, isKey, delegateMap, selector, clazz);
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected static void instantiateAndConfigure(Map<String, ?> configs, boolean isKey, Map<String, Deserializer<?>> delegateMap, String selector, Class<?> clazz) {
        try {
            Deserializer delegate = (Deserializer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            delegate.configure(configs, isKey);
            delegateMap.put(selector.trim(), delegate);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void addDelegate(String selector, Deserializer<?> deserializer) {
        this.delegates.put(selector, deserializer);
    }

    public @Nullable Deserializer<?> removeDelegate(String selector) {
        return this.delegates.remove(selector);
    }

    public Object deserialize(String topic, byte[] data) {
        throw new UnsupportedOperationException();
    }

    public @Nullable Object deserialize(String topic, Headers headers, byte[] data) {
        Deserializer<?> deserializer = this.getDeserializerByHeaders(headers);
        return deserializer == null ? data : (byte[])deserializer.deserialize(topic, headers, data);
    }

    public @Nullable Object deserialize(String topic, Headers headers, ByteBuffer data) {
        Deserializer<?> deserializer = this.getDeserializerByHeaders(headers);
        return deserializer == null ? data : deserializer.deserialize(topic, headers, data);
    }

    private @Nullable Deserializer<?> getDeserializerByHeaders(Headers headers) {
        byte[] value = null;
        String selectorKey = this.selectorKey();
        Header header = headers.lastHeader(selectorKey);
        if (header != null) {
            value = header.value();
        }
        if (value == null) {
            throw new IllegalStateException("No '" + selectorKey + "' header present");
        }
        String selector = new String(value).replaceAll("\"", "");
        Deserializer<?> deserializer = this.delegates.get(selector);
        if (deserializer == null) {
            deserializer = this.trySerdes(selector);
        }
        return deserializer;
    }

    private String selectorKey() {
        return this.forKeys ? "spring.kafka.key.serialization.selector" : "spring.kafka.serialization.selector";
    }

    @Nullable Deserializer<?> trySerdes(String key) {
        try {
            Class clazz = ClassUtils.forName((String)key, (ClassLoader)ClassUtils.getDefaultClassLoader());
            Serde serdeFrom = Serdes.serdeFrom((Class)clazz);
            Deserializer deserializer = serdeFrom.deserializer();
            deserializer.configure(this.autoConfigs, this.forKeys);
            this.delegates.put(key, deserializer);
            return deserializer;
        }
        catch (ClassNotFoundException | IllegalStateException | LinkageError e) {
            this.delegates.put(key, Serdes.serdeFrom(byte[].class).deserializer());
            return null;
        }
    }

    public void close() {
        this.delegates.values().forEach(Deserializer::close);
    }
}

