/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public class ExceptionMatcher {
    private final Map<Class<? extends Throwable>, Boolean> entries;
    private final boolean defaultMatch;
    private boolean traverseCauses;

    public ExceptionMatcher(Collection<Class<? extends Throwable>> exceptionTypes, boolean shouldMatchIfFound) {
        this(ExceptionMatcher.buildEntries(exceptionTypes, shouldMatchIfFound), !shouldMatchIfFound, false);
    }

    protected ExceptionMatcher(Map<Class<? extends Throwable>, Boolean> entries, boolean matchIfNotFound, boolean traverseCauses) {
        this.entries = new HashMap<Class<? extends Throwable>, Boolean>(entries);
        this.defaultMatch = matchIfNotFound;
        this.traverseCauses = traverseCauses;
    }

    private static Map<Class<? extends Throwable>, Boolean> buildEntries(Collection<Class<? extends Throwable>> exceptionType, boolean value) {
        HashMap<Class<? extends Throwable>, Boolean> cache = new HashMap<Class<? extends Throwable>, Boolean>();
        for (Class<? extends Throwable> type : exceptionType) {
            cache.put(type, value);
        }
        return cache;
    }

    public static ExceptionMatcher defaultMatcher() {
        return new ExceptionMatcher(Collections.singletonMap(Exception.class, true), false, false);
    }

    public static Builder forAllowList() {
        return new Builder(true);
    }

    public static Builder forDenyList() {
        return new Builder(false);
    }

    public void setTraverseCauses(boolean traverseCauses) {
        this.traverseCauses = traverseCauses;
    }

    public boolean match(@Nullable Throwable exception) {
        boolean match = this.matchInCache(exception);
        if (!this.traverseCauses || exception == null) {
            return match;
        }
        if (match == this.defaultMatch) {
            Throwable cause = exception;
            do {
                if (this.entries.containsKey(cause.getClass())) {
                    return match;
                }
                cause = cause.getCause();
                match = this.match(cause);
            } while (cause != null && match == this.defaultMatch);
        }
        return match;
    }

    protected Map<Class<? extends Throwable>, Boolean> getEntries() {
        return this.entries;
    }

    private boolean matchInCache(@Nullable Throwable classifiable) {
        if (classifiable == null) {
            return this.defaultMatch;
        }
        Class<?> exceptionClass = classifiable.getClass();
        if (this.entries.containsKey(exceptionClass)) {
            return this.entries.get(exceptionClass);
        }
        Boolean value = null;
        Class<?> cls = exceptionClass.getSuperclass();
        while (!cls.equals(Object.class) && value == null) {
            value = this.entries.get(cls);
            cls = cls.getSuperclass();
        }
        if (value == null) {
            cls = exceptionClass;
            while (!cls.equals(Object.class) && value == null) {
                Class<?> ifc;
                Class<?>[] classArray = cls.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (value = this.entries.get(ifc = classArray[i])) == null; ++i) {
                }
                cls = cls.getSuperclass();
            }
        }
        if (value != null) {
            this.entries.put(exceptionClass, value);
        }
        if (value == null) {
            value = this.defaultMatch;
        }
        return value;
    }

    public static class Builder {
        private final boolean matchIfFound;
        private final Set<Class<? extends Throwable>> exceptionClasses = new LinkedHashSet<Class<? extends Throwable>>();
        private boolean traverseCauses = false;

        protected Builder(boolean matchIfFound) {
            this.matchIfFound = matchIfFound;
        }

        public Builder add(Class<? extends Throwable> exceptionType) {
            Assert.notNull(exceptionType, (String)"Exception class can not be null");
            this.exceptionClasses.add(exceptionType);
            return this;
        }

        public Builder addAll(Collection<Class<? extends Throwable>> exceptionTypes) {
            this.exceptionClasses.addAll(exceptionTypes);
            return this;
        }

        public Builder traverseCauses(boolean traverseCauses) {
            this.traverseCauses = traverseCauses;
            return this;
        }

        public ExceptionMatcher build() {
            return new ExceptionMatcher(ExceptionMatcher.buildEntries(new ArrayList<Class<? extends Throwable>>(this.exceptionClasses), this.matchIfFound), !this.matchIfFound, this.traverseCauses);
        }
    }
}

