/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.event.KafkaEvent;

public class ListenerContainerNoLongerIdleEvent
extends KafkaEvent {
    private static final long serialVersionUID = 1L;
    private final long idleTime;
    private final String listenerId;
    private final transient @Nullable List<TopicPartition> topicPartitions;
    private final transient @Nullable Consumer<?, ?> consumer;

    public ListenerContainerNoLongerIdleEvent(Object source, Object container, long idleTime, String id, @Nullable Collection<TopicPartition> topicPartitions, Consumer<?, ?> consumer) {
        super(source, container);
        this.idleTime = idleTime;
        this.listenerId = id;
        this.topicPartitions = topicPartitions == null ? null : new ArrayList<TopicPartition>(topicPartitions);
        this.consumer = consumer;
    }

    public @Nullable Collection<TopicPartition> getTopicPartitions() {
        return this.topicPartitions == null ? null : Collections.unmodifiableList(this.topicPartitions);
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public @Nullable Consumer<?, ?> getConsumer() {
        return this.consumer;
    }

    public String toString() {
        return "ListenerContainerNoLongerIdleEvent [idleTime=" + (float)this.idleTime / 1000.0f + "s, listenerId=" + this.listenerId + ", container=" + String.valueOf(this.getSource()) + ", topicPartitions=" + String.valueOf(this.topicPartitions) + "]";
    }
}

