/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test.condition;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.kafka.test.EmbeddedKafkaBroker;
import org.springframework.kafka.test.context.EmbeddedKafka;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class EmbeddedKafkaCondition
implements ExecutionCondition,
AfterAllCallback,
ParameterResolver {
    private static final String EMBEDDED_BROKER = "embedded-kafka";
    private static final ThreadLocal<EmbeddedKafkaBroker> BROKERS = new ThreadLocal();

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (BROKERS.get() == null) {
            return false;
        }
        return parameterContext.getParameter().getType().equals(EmbeddedKafkaBroker.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        EmbeddedKafkaBroker broker = this.getBrokerFromStore(context);
        Assert.state((broker != null ? 1 : 0) != 0, (String)"Could not find embedded broker instance");
        return broker;
    }

    public void afterAll(ExtensionContext context) {
        EmbeddedKafkaBroker broker = BROKERS.get();
        if (broker != null) {
            broker.destroy();
            BROKERS.remove();
        }
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        EmbeddedKafkaBroker broker;
        EmbeddedKafka embedded;
        Optional element = context.getElement();
        if (element.isPresent() && !this.springTestContext((AnnotatedElement)element.get()) && (embedded = (EmbeddedKafka)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)((AnnotatedElement)element.get()), EmbeddedKafka.class)) != null && (broker = this.getBrokerFromStore(context)) == null) {
            broker = this.createBroker(embedded);
            BROKERS.set(broker);
            this.getStore(context).put((Object)EMBEDDED_BROKER, (Object)broker);
        }
        return ConditionEvaluationResult.enabled((String)"");
    }

    private boolean springTestContext(AnnotatedElement annotatedElement) {
        return AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)annotatedElement, ExtendWith.class).stream().filter(extended -> Arrays.asList(extended.value()).contains(SpringExtension.class)).findFirst().isPresent();
    }

    private EmbeddedKafkaBroker createBroker(EmbeddedKafka embedded) {
        int[] ports = this.setupPorts(embedded);
        EmbeddedKafkaBroker broker = new EmbeddedKafkaBroker(embedded.count(), embedded.controlledShutdown(), embedded.partitions(), embedded.topics()).zkPort(embedded.zookeeperPort()).kafkaPorts(ports).zkConnectionTimeout(embedded.zkConnectionTimeout()).zkSessionTimeout(embedded.zkSessionTimeout());
        Properties properties = new Properties();
        for (String pair : embedded.brokerProperties()) {
            if (!StringUtils.hasText((String)pair)) continue;
            try {
                properties.load(new StringReader(pair));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to load broker property from [" + pair + "]", ex);
            }
        }
        if (StringUtils.hasText((String)embedded.brokerPropertiesLocation())) {
            Resource propertiesResource = new PathMatchingResourcePatternResolver().getResource(embedded.brokerPropertiesLocation());
            if (!propertiesResource.exists()) {
                throw new IllegalStateException("Failed to load broker properties from [" + propertiesResource + "]: resource does not exist.");
            }
            try (InputStream in = propertiesResource.getInputStream();){
                Properties p = new Properties();
                p.load(in);
                p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)properties::putIfAbsent));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to load broker properties from [" + propertiesResource + "]", ex);
            }
        }
        broker.brokerProperties(properties);
        if (StringUtils.hasText((String)embedded.bootstrapServersProperty())) {
            broker.brokerListProperty(embedded.bootstrapServersProperty());
        }
        broker.afterPropertiesSet();
        return broker;
    }

    private int[] setupPorts(EmbeddedKafka embedded) {
        int[] ports = embedded.ports();
        if (embedded.count() > 1 && ports.length == 1 && ports[0] == 0) {
            ports = new int[embedded.count()];
        }
        return ports;
    }

    private EmbeddedKafkaBroker getBrokerFromStore(ExtensionContext context) {
        return this.getParentStore(context).get((Object)EMBEDDED_BROKER, EmbeddedKafkaBroker.class) == null ? (EmbeddedKafkaBroker)this.getStore(context).get((Object)EMBEDDED_BROKER, EmbeddedKafkaBroker.class) : (EmbeddedKafkaBroker)this.getParentStore(context).get((Object)EMBEDDED_BROKER, EmbeddedKafkaBroker.class);
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
    }

    private ExtensionContext.Store getParentStore(ExtensionContext context) {
        ExtensionContext parent = (ExtensionContext)context.getParent().get();
        return parent.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), parent}));
    }

    public static EmbeddedKafkaBroker getBroker() {
        return BROKERS.get();
    }
}

