/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.mock;

import java.util.ArrayList;
import org.jspecify.annotations.Nullable;
import org.mockito.ArgumentCaptor;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.test.mock.MockMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.GenericMessage;

public final class MockIntegration {
    public static <T> MessageSource<T> mockMessageSource(T payload) {
        return MockIntegration.mockMessageSource(new GenericMessage(payload));
    }

    public static <T> MessageSource<T> mockMessageSource(T payload, T ... payloads) {
        ArrayList<GenericMessage> messages = null;
        if (payloads != null) {
            messages = new ArrayList<GenericMessage>(payloads.length);
            for (T p : payloads) {
                messages.add(new GenericMessage(p));
            }
        }
        return MockIntegration.mockMessageSource(new GenericMessage(payload), messages != null ? messages.toArray(new Message[messages.size()]) : null);
    }

    public static MessageSource<?> mockMessageSource(Message<?> message) {
        MessageSource messageSource = (MessageSource)Mockito.mock(MessageSource.class);
        BDDMockito.given((Object)messageSource.receive()).willReturn(message);
        return messageSource;
    }

    public static MessageSource<?> mockMessageSource(Message<?> message, Message<?> ... messages) {
        MessageSource messageSource = (MessageSource)Mockito.mock(MessageSource.class);
        BDDMockito.given((Object)messageSource.receive()).willReturn(message, (Object[])messages);
        return messageSource;
    }

    public static MockMessageHandler mockMessageHandler() {
        return MockIntegration.mockMessageHandler(null);
    }

    public static MockMessageHandler mockMessageHandler(@Nullable ArgumentCaptor<Message<?>> messageArgumentCaptor) {
        return (MockMessageHandler)((Object)Mockito.spy((Object)((Object)new MockMessageHandler(messageArgumentCaptor))));
    }

    public static ArgumentCaptor<Message<?>> messageArgumentCaptor() {
        return ArgumentCaptor.forClass(Message.class);
    }

    private MockIntegration() {
    }
}

