/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.util;

import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.Nullable;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;

public class OnlyOnceTrigger
implements Trigger {
    private final AtomicBoolean hasRun = new AtomicBoolean();
    private final Instant executionTime;
    private volatile CountDownLatch latch = new CountDownLatch(1);

    public OnlyOnceTrigger() {
        this.executionTime = Instant.now();
    }

    public @Nullable Instant nextExecution(TriggerContext triggerContext) {
        if (this.hasRun.getAndSet(true)) {
            this.latch.countDown();
            return null;
        }
        return this.executionTime;
    }

    public void reset() {
        this.latch = new CountDownLatch(1);
        this.hasRun.set(false);
    }

    public void await() {
        try {
            if (!this.latch.await(10000L, TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("test latch.await() did not count down");
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("test latch.await() interrupted", ex);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.executionTime.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OnlyOnceTrigger other = (OnlyOnceTrigger)obj;
        return this.executionTime.equals(other.executionTime);
    }
}

