/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.jspecify.annotations.Nullable;
import org.springframework.messaging.Message;

public final class PayloadAndHeaderMatcher<T>
extends BaseMatcher<Message<?>> {
    private final T payload;
    private final Map<String, Object> headers;
    private final String @Nullable [] ignoreKeys;

    public static <P> PayloadAndHeaderMatcher<P> sameExceptIgnorableHeaders(Message<P> expected, String ... ignoreKeys) {
        return new PayloadAndHeaderMatcher<P>(expected, ignoreKeys);
    }

    private PayloadAndHeaderMatcher(Message<T> expected, String ... ignoreKeys) {
        this.ignoreKeys = ignoreKeys != null ? Arrays.copyOf(ignoreKeys, ignoreKeys.length) : null;
        this.payload = expected.getPayload();
        this.headers = this.extractHeadersToAssert(expected);
    }

    private Map<String, Object> extractHeadersToAssert(Message<?> operand) {
        HashMap<String, Object> headersToAssert = new HashMap<String, Object>((Map<String, Object>)operand.getHeaders());
        headersToAssert.remove("id");
        headersToAssert.remove("timestamp");
        if (this.ignoreKeys != null) {
            for (String key : this.ignoreKeys) {
                headersToAssert.remove(key);
            }
        }
        return headersToAssert;
    }

    public boolean matches(Object arg) {
        Message input = (Message)arg;
        Map<String, Object> inputHeaders = this.extractHeadersToAssert(input);
        return input.getPayload().equals(this.payload) && inputHeaders.equals(this.headers);
    }

    public void describeTo(Description description) {
        description.appendText("a Message with Headers that match except ID and timestamp for payload: ").appendValue(this.payload).appendText(" and headers: ").appendValue(this.headers);
    }
}

