/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.predicate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.messaging.Message;

public class MessagePredicate
implements Predicate<Message<?>> {
    private final Object payload;
    private final Map<String, Object> headers;
    private final List<String> ignoredHeaders = new ArrayList<String>(Arrays.asList("id", "timestamp"));

    public MessagePredicate(Message<?> operand, String ... ignoredHeaders) {
        this.payload = operand.getPayload();
        if (ignoredHeaders != null) {
            this.ignoredHeaders.addAll(Arrays.asList(ignoredHeaders));
        }
        this.headers = this.getHeaders(operand);
    }

    @Override
    public boolean test(Message<?> input) {
        Map<String, Object> inputHeaders = this.getHeaders(input);
        return input.getPayload().equals(this.payload) && inputHeaders.equals(this.headers);
    }

    private Map<String, Object> getHeaders(Message<?> operand) {
        HashMap<String, Object> headersToFilter = new HashMap<String, Object>((Map<String, Object>)operand.getHeaders());
        this.ignoredHeaders.forEach(headersToFilter::remove);
        return headersToFilter;
    }
}

