/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.matcher;

import java.util.Date;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.springframework.integration.test.matcher.MapContentMatchers;
import org.springframework.messaging.Message;

public final class HeaderMatcher<T>
extends TypeSafeMatcher<Message<T>> {
    private final Matcher<?> matcher;

    private HeaderMatcher(Matcher<?> matcher) {
        this.matcher = matcher;
    }

    public boolean matchesSafely(Message<T> item) {
        return this.matcher.matches((Object)item.getHeaders());
    }

    public void describeTo(Description description) {
        description.appendText("a Message with Headers containing ").appendDescriptionOf(this.matcher);
    }

    public static <P, V> HeaderMatcher<P> hasHeader(String key, V value) {
        return new HeaderMatcher(Matchers.hasEntry((Object)key, value));
    }

    public static <P, V> HeaderMatcher<P> hasHeader(String key, Matcher<V> valueMatcher) {
        return new HeaderMatcher(Matchers.hasEntry((Matcher)Matchers.is((Object)key), valueMatcher));
    }

    public static <P> HeaderMatcher<P> hasHeaderKey(String key) {
        return new HeaderMatcher(Matchers.hasKey((Object)key));
    }

    public static <P> HeaderMatcher<P> hasAllHeaders(Map<String, ?> entries) {
        return new HeaderMatcher(MapContentMatchers.hasAllEntries(entries));
    }

    public static <P, V> HeaderMatcher<P> hasMessageId(V value) {
        return new HeaderMatcher(Matchers.hasEntry((Object)"id", value));
    }

    public static <P, V> HeaderMatcher<P> hasCorrelationId(V value) {
        return new HeaderMatcher(Matchers.hasEntry((Object)"correlationId", value));
    }

    public static <P> HeaderMatcher<P> hasSequenceNumber(Integer value) {
        return HeaderMatcher.hasSequenceNumber((Matcher<Integer>)Matchers.is((Object)value));
    }

    public static <P> HeaderMatcher<P> hasSequenceNumber(Matcher<Integer> matcher) {
        return new HeaderMatcher(Matchers.hasEntry((Matcher)Matchers.is((Object)"sequenceNumber"), matcher));
    }

    public static <P> HeaderMatcher<P> hasSequenceSize(Integer value) {
        return HeaderMatcher.hasSequenceSize((Matcher<Integer>)Matchers.is((Object)value));
    }

    public static <P> HeaderMatcher<P> hasSequenceSize(Matcher<Integer> value) {
        return new HeaderMatcher(Matchers.hasEntry((Matcher)Matchers.is((Object)"sequenceSize"), value));
    }

    public static <P> HeaderMatcher<P> hasExpirationDate(Date value) {
        return HeaderMatcher.hasExpirationDate((Matcher<Long>)Matchers.is((Object)value.getTime()));
    }

    public static <P> HeaderMatcher<P> hasExpirationDate(Matcher<Long> matcher) {
        return new HeaderMatcher(Matchers.hasEntry((Matcher)Matchers.is((Object)"expirationDate"), matcher));
    }

    public static <P> HeaderMatcher<P> hasTimestamp(Date value) {
        return HeaderMatcher.hasTimestamp((Matcher<Long>)Matchers.is((Object)value.getTime()));
    }

    public static <P> HeaderMatcher<P> hasTimestamp(Matcher<Long> matcher) {
        return new HeaderMatcher(Matchers.hasEntry((Matcher)Matchers.is((Object)"timestamp"), matcher));
    }
}

