/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jmx.inbound;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class NotificationListeningMessageProducer
extends MessageProducerSupport
implements NotificationListener,
ApplicationListener<ContextRefreshedEvent> {
    private final AtomicBoolean listenerRegisteredOnStartup = new AtomicBoolean();
    private MBeanServerConnection server;
    private ObjectName[] mBeanObjectNames;
    private @Nullable NotificationFilter filter;
    private @Nullable Object handback;

    public void setServer(MBeanServerConnection server) {
        this.server = server;
    }

    public void setObjectName(ObjectName ... objectNames) {
        Assert.notEmpty((Object[])objectNames, (String)"'objectNames' must contain at least one ObjectName");
        this.mBeanObjectNames = Arrays.copyOf(objectNames, objectNames.length);
    }

    public void setFilter(NotificationFilter filter) {
        this.filter = filter;
    }

    public void setHandback(Object handback) {
        this.handback = handback;
    }

    @Override
    public void handleNotification(Notification notification, @Nullable Object handback) {
        this.logger.info(() -> "received notification: " + String.valueOf(notification) + ", and handback: " + String.valueOf(handback));
        AbstractIntegrationMessageBuilder builder = this.getMessageBuilderFactory().withPayload((Object)notification);
        if (handback != null) {
            builder.setHeader("jmx_notificationHandback", handback);
        }
        Message message = builder.build();
        this.sendMessage(message);
    }

    public String getComponentType() {
        return "jmx:notification-listening-channel-adapter";
    }

    protected void onInit() {
        super.onInit();
        Assert.notNull((Object)this.server, (String)"MBeanServer is required.");
        Assert.notNull((Object)this.mBeanObjectNames, (String)"An ObjectName is required.");
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.listenerRegisteredOnStartup.getAndSet(true) && this.isAutoStartup()) {
            this.doStart();
        }
    }

    protected void doStart() {
        if (!this.listenerRegisteredOnStartup.get()) {
            return;
        }
        this.logger.debug((CharSequence)"Registering to receive notifications");
        try {
            Collection<ObjectName> objectNames = this.retrieveMBeanNames();
            if (objectNames.isEmpty()) {
                this.logger.error(() -> "No MBeans found matching ObjectName pattern(s): " + Arrays.toString(this.mBeanObjectNames));
            }
            for (ObjectName objectName : objectNames) {
                this.server.addNotificationListener(objectName, this, this.filter, this.handback);
            }
        }
        catch (InstanceNotFoundException ex) {
            throw new IllegalStateException("Failed to find MBean instance.", ex);
        }
        catch (IOException ex) {
            throw new IllegalStateException("IOException on MBeanServerConnection.", ex);
        }
    }

    protected void doStop() {
        this.logger.debug((CharSequence)"Unregistering notifications");
        Collection<ObjectName> objectNames = this.retrieveMBeanNames();
        for (ObjectName objectName : objectNames) {
            try {
                this.server.removeNotificationListener(objectName, this, this.filter, this.handback);
            }
            catch (InstanceNotFoundException ex) {
                this.logger.error((Throwable)ex, (CharSequence)"Failed to find MBean instance.");
            }
            catch (ListenerNotFoundException ex) {
                this.logger.error((Throwable)ex, (CharSequence)"Failed to find NotificationListener.");
            }
            catch (IOException ex) {
                this.logger.error((Throwable)ex, (CharSequence)"IOException on MBeanServerConnection.");
            }
        }
    }

    protected Collection<ObjectName> retrieveMBeanNames() {
        ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>(this.mBeanObjectNames.length);
        for (ObjectName pattern : this.mBeanObjectNames) {
            Set<ObjectInstance> mBeanInfos;
            try {
                mBeanInfos = this.server.queryMBeans(pattern, null);
            }
            catch (IOException ex) {
                throw new IllegalStateException("IOException on MBeanServerConnection.", ex);
            }
            if (mBeanInfos.isEmpty()) {
                this.logger.debug(() -> "No MBeans found matching pattern: " + String.valueOf(pattern));
            }
            for (ObjectInstance instance : mBeanInfos) {
                this.logger.debug(() -> "Found MBean: " + instance.getObjectName().toString());
                objectNames.add(instance.getObjectName());
            }
        }
        return objectNames;
    }
}

