/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.inbound;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.context.Lifecycle;
import org.springframework.expression.Expression;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.file.DefaultDirectoryScanner;
import org.springframework.integration.file.DirectoryScanner;
import org.springframework.integration.file.FileLocker;
import org.springframework.integration.file.HeadDirectoryScanner;
import org.springframework.integration.file.filters.DiscardAwareFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.ResettableFileListFilter;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class FileReadingMessageSource
extends AbstractMessageSource<File>
implements ManageableLifecycle {
    private static final int DEFAULT_INTERNAL_QUEUE_CAPACITY = 5;
    private final AtomicBoolean running = new AtomicBoolean();
    private final Queue<DirFile> toBeReceived;
    private Expression directoryExpression;
    private DirectoryScanner scanner = new DefaultDirectoryScanner();
    private boolean scannerExplicitlySet;
    private boolean autoCreateDirectory = true;
    private boolean scanEachPoll = false;
    private @Nullable FileListFilter<File> filter;
    private @Nullable FileLocker locker;
    private boolean useWatchService;
    private WatchEventType[] watchEvents = new WatchEventType[]{WatchEventType.CREATE};
    private int watchMaxDepth = Integer.MAX_VALUE;
    private Predicate<Path> watchDirPredicate = path -> true;

    public FileReadingMessageSource() {
        this(null);
    }

    public FileReadingMessageSource(int internalQueueCapacity) {
        this(null);
        Assert.isTrue((internalQueueCapacity > 0 ? 1 : 0) != 0, (String)"Cannot create a queue with non positive capacity");
        this.scanner = new HeadDirectoryScanner(internalQueueCapacity);
    }

    public FileReadingMessageSource(@Nullable Comparator<File> receptionOrderComparator) {
        Comparator comparatorToUse = null;
        if (receptionOrderComparator != null) {
            comparatorToUse = (dirFile1, dirFile2) -> receptionOrderComparator.compare(dirFile1.file, dirFile2.file);
        }
        this.toBeReceived = new PriorityBlockingQueue<DirFile>(5, comparatorToUse);
    }

    public void setDirectory(File directory) {
        Assert.notNull((Object)directory, (String)"directory must not be null");
        this.setDirectoryExpression((Expression)new ValueExpression((Object)directory));
    }

    public void setDirectoryExpression(Expression directoryExpression) {
        Assert.notNull((Object)directoryExpression, (String)"'directoryExpression' must not be null");
        this.directoryExpression = directoryExpression;
    }

    public void setScanner(DirectoryScanner scanner) {
        Assert.notNull((Object)scanner, (String)"'scanner' must not be null.");
        this.scanner = scanner;
        this.scannerExplicitlySet = true;
    }

    public DirectoryScanner getScanner() {
        return this.scanner;
    }

    public void setAutoCreateDirectory(boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setFilter(FileListFilter<File> filter) {
        Assert.notNull(filter, (String)"'filter' must not be null");
        this.filter = filter;
    }

    public void setLocker(FileLocker locker) {
        Assert.notNull((Object)locker, (String)"'fileLocker' must not be null.");
        this.locker = locker;
    }

    public void setScanEachPoll(boolean scanEachPoll) {
        this.scanEachPoll = scanEachPoll;
    }

    public void setUseWatchService(boolean useWatchService) {
        this.useWatchService = useWatchService;
    }

    public boolean isUseWatchService() {
        return this.useWatchService;
    }

    public void setWatchEvents(WatchEventType ... watchEvents) {
        Assert.notEmpty((Object[])watchEvents, (String)"'watchEvents' must not be empty.");
        Assert.noNullElements((Object[])watchEvents, (String)"'watchEvents' must not contain null elements.");
        Assert.state((!this.running.get() ? 1 : 0) != 0, (String)"Cannot change watch events while running.");
        this.watchEvents = Arrays.copyOf(watchEvents, watchEvents.length);
    }

    public void setWatchMaxDepth(int watchMaxDepth) {
        this.watchMaxDepth = watchMaxDepth;
    }

    public void setWatchDirPredicate(Predicate<Path> watchDirPredicate) {
        Assert.notNull(watchDirPredicate, (String)"'watchDirPredicate' must not be null.");
        this.watchDirPredicate = watchDirPredicate;
    }

    public String getComponentType() {
        return "file:inbound-channel-adapter";
    }

    public void start() {
        if (!this.running.getAndSet(true)) {
            DirectoryScanner directoryScanner;
            if (this.directoryExpression instanceof ValueExpression) {
                File directoryToCreate = (File)this.directoryExpression.getValue(File.class);
                if (directoryToCreate == null || !directoryToCreate.exists() && this.autoCreateDirectory && !directoryToCreate.mkdirs()) {
                    throw new IllegalStateException("Cannot create directory or its parents: " + String.valueOf(directoryToCreate));
                }
                Assert.isTrue((boolean)directoryToCreate.exists(), () -> "Source directory [" + String.valueOf(directoryToCreate) + "] does not exist.");
                Assert.isTrue((boolean)directoryToCreate.isDirectory(), () -> "Source path [" + String.valueOf(directoryToCreate) + "] does not point to a directory.");
                Assert.isTrue((boolean)directoryToCreate.canRead(), () -> "Source directory [" + String.valueOf(directoryToCreate) + "] is not readable.");
                DirectoryScanner directoryScanner2 = this.scanner;
                if (directoryScanner2 instanceof WatchServiceDirectoryScanner) {
                    WatchServiceDirectoryScanner watchServiceDirectoryScanner = (WatchServiceDirectoryScanner)directoryScanner2;
                    watchServiceDirectoryScanner.directory = directoryToCreate;
                }
            }
            if ((directoryScanner = this.scanner) instanceof Lifecycle) {
                Lifecycle lifecycle = (Lifecycle)directoryScanner;
                lifecycle.start();
            }
        }
    }

    public void stop() {
        DirectoryScanner directoryScanner;
        if (this.running.getAndSet(false) && (directoryScanner = this.scanner) instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)directoryScanner;
            lifecycle.stop();
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    protected void onInit() {
        Assert.notNull((Object)this.directoryExpression, (String)"'directoryExpression' must not be null");
        Assert.state((!this.scannerExplicitlySet || !this.useWatchService ? 1 : 0) != 0, () -> "The 'scanner' and 'useWatchService' options are mutually exclusive: " + String.valueOf(this.scanner));
        if (this.useWatchService) {
            this.scanner = new WatchServiceDirectoryScanner();
        }
        Assert.state((!this.scannerExplicitlySet || this.filter == null && this.locker == null ? 1 : 0) != 0, () -> "When using an external scanner the 'filter' and 'locker' options should not be used. Instead, set these options on the external DirectoryScanner: " + String.valueOf(this.scanner));
        if (this.filter != null) {
            this.scanner.setFilter(this.filter);
        }
        if (this.locker != null) {
            this.scanner.setLocker(this.locker);
        }
    }

    protected @Nullable AbstractIntegrationMessageBuilder<File> doReceive() {
        if (this.scanEachPoll || this.toBeReceived.isEmpty()) {
            this.scanInputDirectory();
        }
        DirFile dirFile = this.toBeReceived.poll();
        while (dirFile != null && !this.scanner.tryClaim(dirFile.file)) {
            dirFile = this.toBeReceived.poll();
        }
        if (dirFile != null) {
            return this.getMessageBuilderFactory().withPayload((Object)dirFile.file).setHeader("file_relativePath", (Object)dirFile.root.toPath().relativize(dirFile.file.toPath()).toString()).setHeader("file_name", (Object)dirFile.file.getName()).setHeader("file_originalFile", (Object)dirFile.file);
        }
        return null;
    }

    private void scanInputDirectory() {
        File directory = (File)this.directoryExpression.getValue(this.getEvaluationContext(), File.class);
        Assert.notNull((Object)directory, (String)"'directoryExpression' must not evaluate to null");
        DirectoryScanner directoryScanner = this.scanner;
        if (directoryScanner instanceof WatchServiceDirectoryScanner) {
            WatchServiceDirectoryScanner watchServiceDirectoryScanner = (WatchServiceDirectoryScanner)directoryScanner;
            if (!watchServiceDirectoryScanner.directory.equals(directory)) {
                watchServiceDirectoryScanner.stop();
                watchServiceDirectoryScanner.directory = directory;
                watchServiceDirectoryScanner.start();
            }
        }
        List<File> filteredFiles = this.scanner.listFiles(directory);
        for (File file : filteredFiles) {
            this.toBeReceived.add(new DirFile(file, directory));
        }
        if (!filteredFiles.isEmpty()) {
            this.logger.debug(() -> "Added to queue: " + String.valueOf(filteredFiles));
        }
    }

    public void onFailure(Message<File> failedMessage) {
        File root;
        this.logger.warn(() -> "Failed to send: " + String.valueOf(failedMessage));
        String relativePath = (String)failedMessage.getHeaders().get((Object)"file_relativePath", String.class);
        File file = (File)failedMessage.getPayload();
        if (relativePath != null) {
            String absolutePath = file.getAbsolutePath();
            String rootPath = absolutePath.substring(0, absolutePath.length() - relativePath.length());
            root = new File(rootPath);
        } else {
            root = file.getParentFile();
        }
        this.toBeReceived.offer(new DirFile(file, root));
    }

    public static enum WatchEventType {
        CREATE(StandardWatchEventKinds.ENTRY_CREATE),
        MODIFY(StandardWatchEventKinds.ENTRY_MODIFY),
        DELETE(StandardWatchEventKinds.ENTRY_DELETE);

        private final WatchEvent.Kind<Path> kind;

        private WatchEventType(WatchEvent.Kind<Path> kind) {
            this.kind = kind;
        }
    }

    private final class WatchServiceDirectoryScanner
    extends DefaultDirectoryScanner
    implements ManageableLifecycle {
        private final ConcurrentMap<Path, WatchKey> pathKeys = new ConcurrentHashMap<Path, WatchKey>();
        private final WatchEvent.Kind<?>[] kinds;
        private final Set<File> filesToPoll = ConcurrentHashMap.newKeySet();
        private WatchService watcher;
        private volatile File directory;

        WatchServiceDirectoryScanner() {
            this.kinds = (WatchEvent.Kind[])Arrays.stream(FileReadingMessageSource.this.watchEvents).map(watchEventType -> watchEventType.kind).toArray(WatchEvent.Kind[]::new);
        }

        @Override
        public void setFilter(FileListFilter<File> filter) {
            if (filter instanceof DiscardAwareFileListFilter) {
                DiscardAwareFileListFilter discardAwareFileListFilter = (DiscardAwareFileListFilter)filter;
                discardAwareFileListFilter.addDiscardCallback(this.filesToPoll::add);
            }
            super.setFilter(filter);
        }

        public void start() {
            if (this.directory == null) {
                File directoryToSet = (File)FileReadingMessageSource.this.directoryExpression.getValue(FileReadingMessageSource.this.getEvaluationContext(), File.class);
                Assert.notNull((Object)directoryToSet, (String)"'directoryExpression' must not evaluate to null");
                this.directory = directoryToSet;
            }
            try {
                this.watcher = FileSystems.getDefault().newWatchService();
                Set<File> initialFiles = this.walkDirectory(this.directory.toPath(), null);
                initialFiles.addAll(this.filesFromEvents());
                this.filesToPoll.addAll(initialFiles);
            }
            catch (IOException ex) {
                FileReadingMessageSource.this.logger.error((Throwable)ex, () -> "Failed to create watcher for " + String.valueOf(this.directory));
            }
        }

        public void stop() {
            try {
                this.pathKeys.forEach((path, watchKey) -> watchKey.cancel());
                this.watcher.close();
                this.pathKeys.clear();
                this.filesToPoll.clear();
            }
            catch (IOException ex) {
                FileReadingMessageSource.this.logger.error((Throwable)ex, () -> "Failed to close watcher for " + String.valueOf(this.directory));
            }
        }

        public boolean isRunning() {
            return true;
        }

        @Override
        protected File[] listEligibleFiles(File directory) {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            Iterator<File> iterator = this.filesToPoll.iterator();
            while (iterator.hasNext()) {
                files.add(iterator.next());
                iterator.remove();
            }
            files.addAll(this.filesFromEvents());
            return files.toArray(new File[0]);
        }

        private Set<File> filesFromEvents() {
            WatchKey key = this.watcher.poll();
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            while (key != null) {
                File parentDir = ((Path)key.watchable()).toAbsolutePath().toFile();
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> watchEventKind = event.kind();
                    if (StandardWatchEventKinds.ENTRY_CREATE.equals(watchEventKind) || StandardWatchEventKinds.ENTRY_MODIFY.equals(watchEventKind) || StandardWatchEventKinds.ENTRY_DELETE.equals(watchEventKind)) {
                        this.processFilesFromNormalEvent(files, parentDir, event);
                        continue;
                    }
                    if (!StandardWatchEventKinds.OVERFLOW.equals(watchEventKind)) continue;
                    this.processFilesFromOverflowEvent(files, event);
                }
                key.reset();
                key = this.watcher.poll();
            }
            return files;
        }

        private void processFilesFromNormalEvent(Set<File> files, File parentDir, WatchEvent<?> event) {
            Path item = (Path)event.context();
            File file = new File(parentDir, item.toFile().getName());
            FileReadingMessageSource.this.logger.debug(() -> "Watch event [" + String.valueOf(event.kind()) + "] for file [" + String.valueOf(file) + "]");
            if (StandardWatchEventKinds.ENTRY_DELETE.equals(event.kind())) {
                boolean fileRemoved;
                FileListFilter<File> fileListFilter;
                Path filePath = file.toPath();
                if (this.pathKeys.containsKey(filePath)) {
                    WatchKey watchKey = (WatchKey)this.pathKeys.remove(filePath);
                    watchKey.cancel();
                }
                if ((fileListFilter = this.getFilter()) instanceof ResettableFileListFilter) {
                    ResettableFileListFilter resettableFileListFilter = (ResettableFileListFilter)fileListFilter;
                    resettableFileListFilter.remove(file);
                }
                if (fileRemoved = files.remove(file)) {
                    FileReadingMessageSource.this.logger.debug(() -> "The file [" + String.valueOf(file) + "] has been removed from the queue because of DELETE event.");
                }
            } else if (file.exists()) {
                if (file.isDirectory()) {
                    files.addAll(this.walkDirectory(file.toPath(), event.kind()));
                } else {
                    files.remove(file);
                    files.add(file);
                }
            } else {
                FileReadingMessageSource.this.logger.debug(() -> "A file [" + String.valueOf(file) + "] for the event [" + String.valueOf(event.kind()) + "] doesn't exist. Ignored. Maybe DELETE event is not watched ?");
            }
        }

        private void processFilesFromOverflowEvent(Set<File> files, WatchEvent<?> event) {
            Object obj;
            FileReadingMessageSource.this.logger.debug(() -> "Watch event [" + String.valueOf(StandardWatchEventKinds.OVERFLOW) + "] with context [" + String.valueOf(event.context()) + "]");
            for (WatchKey watchKey : this.pathKeys.values()) {
                watchKey.cancel();
            }
            this.pathKeys.clear();
            if (event.context() != null && (obj = event.context()) instanceof Path) {
                Path path = (Path)obj;
                files.addAll(this.walkDirectory(path, event.kind()));
            } else {
                files.addAll(this.walkDirectory(this.directory.toPath(), event.kind()));
            }
        }

        private Set<File> walkDirectory(Path directoryToWalk, final @Nullable WatchEvent.Kind<?> kind) {
            final LinkedHashSet<File> walkedFiles = new LinkedHashSet<File>();
            try {
                this.registerWatch(directoryToWalk);
                Files.walkFileTree(directoryToWalk, Collections.emptySet(), FileReadingMessageSource.this.watchMaxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){
                    final /* synthetic */ WatchServiceDirectoryScanner this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (this.this$1.FileReadingMessageSource.this.watchDirPredicate.test(dir)) {
                            this.this$1.registerWatch(dir);
                            return FileVisitResult.CONTINUE;
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        FileVisitResult fileVisitResult = super.visitFile(file, attrs);
                        if (!StandardWatchEventKinds.ENTRY_MODIFY.equals(kind)) {
                            walkedFiles.add(file.toFile());
                        }
                        return fileVisitResult;
                    }
                });
            }
            catch (IOException ex) {
                FileReadingMessageSource.this.logger.error((Throwable)ex, () -> "Failed to walk directory: " + String.valueOf(directoryToWalk));
            }
            return walkedFiles;
        }

        private void registerWatch(Path dir) throws IOException {
            if (!this.pathKeys.containsKey(dir)) {
                FileReadingMessageSource.this.logger.debug(() -> "registering: " + String.valueOf(dir) + " for file events");
                WatchKey watchKey = dir.register(this.watcher, this.kinds);
                this.pathKeys.putIfAbsent(dir, watchKey);
            }
        }
    }

    private record DirFile(File file, File root) implements Comparable<DirFile>
    {
        @Override
        public int compareTo(DirFile other) {
            return this.file.compareTo(other.file);
        }
    }
}

