/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import java.io.File;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.TaskExecutor;
import org.springframework.integration.JavaUtils;
import org.springframework.integration.file.tail.ApacheCommonsFileTailingMessageProducer;
import org.springframework.integration.file.tail.FileTailingMessageProducerSupport;
import org.springframework.integration.file.tail.OSDelegatingFileTailingMessageProducer;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.messaging.MessageChannel;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FileTailInboundChannelAdapterFactoryBean
extends AbstractFactoryBean<FileTailingMessageProducerSupport>
implements BeanNameAware,
SmartLifecycle,
ApplicationEventPublisherAware {
    private @Nullable String nativeOptions;
    private boolean enableStatusReader = true;
    private @Nullable Long idleEventInterval;
    private @Nullable File file;
    private @Nullable TaskExecutor taskExecutor;
    private @Nullable TaskScheduler taskScheduler;
    private @Nullable Long delay;
    private @Nullable Long fileDelay;
    private @Nullable Boolean end;
    private @Nullable Boolean reopen;
    private FileTailingMessageProducerSupport tailAdapter;
    private String beanName;
    private @Nullable MessageChannel outputChannel;
    private @Nullable MessageChannel errorChannel;
    private @Nullable String outputChannelName;
    private @Nullable String errorChannelName;
    private @Nullable Boolean autoStartup;
    private @Nullable Integer phase;
    private ApplicationEventPublisher applicationEventPublisher;
    private long sendTimeout;
    private boolean shouldTrack;
    private @Nullable ErrorMessageStrategy errorMessageStrategy;

    public void setNativeOptions(String nativeOptions) {
        if (StringUtils.hasText((String)nativeOptions)) {
            this.nativeOptions = nativeOptions;
        }
    }

    public void setEnableStatusReader(boolean enableStatusReader) {
        this.enableStatusReader = enableStatusReader;
    }

    public void setIdleEventInterval(long idleEventInterval) {
        this.idleEventInterval = idleEventInterval;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void setDelay(Long delay) {
        this.delay = delay;
    }

    public void setFileDelay(Long fileDelay) {
        this.fileDelay = fileDelay;
    }

    public void setEnd(Boolean end) {
        this.end = end;
    }

    public void setReopen(Boolean reopen) {
        this.reopen = reopen;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setOutputChannelName(String outputChannelName) {
        this.outputChannelName = outputChannelName;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void setErrorChannelName(String errorChannelName) {
        this.errorChannelName = errorChannelName;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setShouldTrack(boolean shouldTrack) {
        this.shouldTrack = shouldTrack;
    }

    public void setErrorMessageStrategy(ErrorMessageStrategy errorMessageStrategy) {
        this.errorMessageStrategy = errorMessageStrategy;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void start() {
        this.tailAdapter.start();
    }

    public void stop() {
        this.tailAdapter.stop();
    }

    public boolean isRunning() {
        return this.tailAdapter.isRunning();
    }

    public int getPhase() {
        return this.tailAdapter.getPhase();
    }

    public boolean isAutoStartup() {
        return this.tailAdapter.isAutoStartup();
    }

    public void stop(Runnable callback) {
        this.tailAdapter.stop(callback);
    }

    public Class<?> getObjectType() {
        return ((Object)((Object)this.tailAdapter)).getClass();
    }

    protected FileTailingMessageProducerSupport createInstance() {
        FileTailingMessageProducerSupport adapter;
        if (this.delay == null && this.end == null && this.reopen == null) {
            adapter = new OSDelegatingFileTailingMessageProducer();
            adapter.setEnableStatusReader(this.enableStatusReader);
            if (this.nativeOptions != null) {
                adapter.setOptions(this.nativeOptions);
            }
        } else {
            Assert.isTrue((this.nativeOptions == null ? 1 : 0) != 0, (String)"'native-options' is not allowed with 'delay', 'end', or 'reopen'");
            ApacheCommonsFileTailingMessageProducer apache = new ApacheCommonsFileTailingMessageProducer();
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.delay, apache::setPollingDelay).acceptIfNotNull((Object)this.end, apache::setEnd).acceptIfNotNull((Object)this.reopen, apache::setReopen);
            adapter = apache;
        }
        Assert.notNull((Object)this.file, (String)"The 'file' is required.");
        adapter.setFile(this.file);
        adapter.setBeanName(this.beanName);
        adapter.setSendTimeout(this.sendTimeout);
        adapter.setShouldTrack(this.shouldTrack);
        BeanFactory beanFactory = this.getBeanFactory();
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.taskExecutor, adapter::setTaskExecutor).acceptIfNotNull((Object)this.taskScheduler, arg_0 -> ((FileTailingMessageProducerSupport)adapter).setTaskScheduler(arg_0)).acceptIfNotNull((Object)this.fileDelay, adapter::setTailAttemptsDelay).acceptIfNotNull((Object)this.idleEventInterval, adapter::setIdleEventInterval).acceptIfNotNull((Object)this.autoStartup, arg_0 -> ((FileTailingMessageProducerSupport)adapter).setAutoStartup(arg_0)).acceptIfNotNull((Object)this.phase, arg_0 -> ((FileTailingMessageProducerSupport)adapter).setPhase(arg_0)).acceptIfNotNull((Object)this.applicationEventPublisher, adapter::setApplicationEventPublisher).acceptIfNotNull((Object)this.outputChannel, arg_0 -> ((FileTailingMessageProducerSupport)adapter).setOutputChannel(arg_0)).acceptIfNotNull((Object)this.outputChannelName, arg_0 -> ((FileTailingMessageProducerSupport)adapter).setOutputChannelName(arg_0)).acceptIfNotNull((Object)this.errorChannel, arg_0 -> ((FileTailingMessageProducerSupport)adapter).setErrorChannel(arg_0)).acceptIfNotNull((Object)this.errorChannelName, arg_0 -> ((FileTailingMessageProducerSupport)adapter).setErrorChannelName(arg_0)).acceptIfNotNull((Object)this.errorMessageStrategy, arg_0 -> ((FileTailingMessageProducerSupport)adapter).setErrorMessageStrategy(arg_0)).acceptIfNotNull((Object)beanFactory, arg_0 -> ((FileTailingMessageProducerSupport)adapter).setBeanFactory(arg_0));
        adapter.afterPropertiesSet();
        this.tailAdapter = adapter;
        return adapter;
    }
}

