/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.file.DefaultDirectoryScanner;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;

public class HeadDirectoryScanner
extends DefaultDirectoryScanner {
    private final HeadFilter headFilter;

    public HeadDirectoryScanner(int maxNumberOfFiles) {
        this.headFilter = new HeadFilter(maxNumberOfFiles);
        this.setFilter(this.headFilter);
    }

    @Override
    public final void setFilter(FileListFilter<File> filter) {
        if (filter instanceof CompositeFileListFilter) {
            ((CompositeFileListFilter)filter).addFilter(this.headFilter);
            super.setFilter(filter);
        } else {
            CompositeFileListFilter<File> compositeFilter = new CompositeFileListFilter<File>();
            compositeFilter.addFilter(filter).addFilter(this.headFilter);
            super.setFilter(compositeFilter);
        }
    }

    private record HeadFilter(int maxNumberOfFiles) implements FileListFilter<File>
    {
        public List<File> filterFiles(File @Nullable [] files) {
            return files == null ? List.of() : Arrays.asList(files).subList(0, Math.min(files.length, this.maxNumberOfFiles));
        }
    }
}

