/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.core.EncodingUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class LinkBuilderSupport<T extends LinkBuilder>
implements LinkBuilder {
    private final List<Affordance> affordances;
    private UriComponents components;

    protected LinkBuilderSupport(UriComponents builder) {
        this(builder, Collections.emptyList());
    }

    protected LinkBuilderSupport(UriComponents components, List<Affordance> affordances) {
        Assert.notNull((Object)components, (String)"UriComponents must not be null!");
        Assert.notNull(affordances, (String)"Affordances must not be null!");
        this.affordances = affordances;
        this.components = components;
    }

    public T slash(@Nullable Object object) {
        Object object2 = object = object instanceof Optional ? ((Optional)object).orElse(null) : object;
        if (object == null) {
            return this.getThis();
        }
        String path = object.toString();
        if (path.endsWith("#")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!StringUtils.hasText((String)path)) {
            return this.getThis();
        }
        path = path.startsWith("/") ? path : "/".concat(path);
        return this.slash(UriComponentsBuilder.fromUriString((String)path).build(), false);
    }

    protected T slash(UriComponents components, boolean encoded) {
        UriComponentsBuilder builder = UriComponentsBuilder.newInstance().uriComponents(this.components);
        for (String pathSegment : components.getPathSegments()) {
            builder.pathSegment(new String[]{encoded ? pathSegment : EncodingUtils.encodePath(pathSegment)});
        }
        String fragment = components.getFragment();
        if (fragment != null && !fragment.trim().isEmpty()) {
            builder.fragment(encoded ? fragment : EncodingUtils.encodeFragment(fragment));
        }
        return this.createNewInstance(builder.query(components.getQuery()).build(), this.affordances);
    }

    @Override
    public URI toUri() {
        return this.components.toUri().normalize();
    }

    public T addAffordances(Collection<Affordance> affordances) {
        ArrayList<Affordance> newAffordances = new ArrayList<Affordance>();
        newAffordances.addAll(this.affordances);
        newAffordances.addAll(affordances);
        return this.createNewInstance(this.components, newAffordances);
    }

    @Override
    public Link withRel(LinkRelation rel) {
        return Link.of(this.toString(), rel).withAffordances(this.affordances);
    }

    @Override
    public Link withSelfRel() {
        return this.withRel(IanaLinkRelations.SELF);
    }

    public String toString() {
        return this.components.toUriString();
    }

    protected abstract T getThis();

    protected abstract T createNewInstance(UriComponents var1, List<Affordance> var2);

    public List<Affordance> getAffordances() {
        return this.affordances;
    }
}

