/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsDeserializers;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsProperty;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NON_PRIVATE)
@JsonIgnoreProperties(value={"httpMethod", "contentTypes"})
@JsonPropertyOrder(value={"title", "method", "contentType", "properties"})
final class HalFormsTemplate {
    static final String DEFAULT_KEY = "default";
    private String title;
    private HttpMethod httpMethod;
    private List<HalFormsProperty> properties;
    private List<MediaType> contentTypes;

    private HalFormsTemplate() {
        this(null, null, Collections.emptyList(), Collections.emptyList());
    }

    private HalFormsTemplate(String title, HttpMethod httpMethod, List<HalFormsProperty> properties, List<MediaType> contentTypes) {
        this.title = title;
        this.httpMethod = httpMethod;
        this.properties = properties;
        this.contentTypes = contentTypes;
    }

    static HalFormsTemplate forMethod(HttpMethod httpMethod) {
        return new HalFormsTemplate().withHttpMethod(httpMethod);
    }

    HalFormsTemplate withTitle(String title) {
        return this.title == title ? this : new HalFormsTemplate(title, this.httpMethod, this.properties, this.contentTypes);
    }

    private HalFormsTemplate withHttpMethod(HttpMethod httpMethod) {
        return this.httpMethod == httpMethod ? this : new HalFormsTemplate(this.title, httpMethod, this.properties, this.contentTypes);
    }

    HalFormsTemplate andProperty(HalFormsProperty property) {
        Assert.notNull((Object)property, (String)"Property must not be null!");
        ArrayList<HalFormsProperty> properties = new ArrayList<HalFormsProperty>(this.properties);
        properties.add(property);
        return new HalFormsTemplate(this.title, this.httpMethod, properties, this.contentTypes);
    }

    HalFormsTemplate withProperties(List<HalFormsProperty> properties) {
        return this.properties == properties ? this : new HalFormsTemplate(this.title, this.httpMethod, properties, this.contentTypes);
    }

    HalFormsTemplate andContentType(MediaType mediaType) {
        Assert.notNull((Object)mediaType, (String)"Media type must not be null!");
        ArrayList<MediaType> contentTypes = new ArrayList<MediaType>(this.contentTypes);
        contentTypes.add(mediaType);
        return new HalFormsTemplate(this.title, this.httpMethod, this.properties, contentTypes);
    }

    HalFormsTemplate withContentTypes(List<MediaType> contentTypes) {
        return this.contentTypes == contentTypes ? this : new HalFormsTemplate(this.title, this.httpMethod, this.properties, contentTypes);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    String getContentType() {
        return StringUtils.collectionToDelimitedString(this.contentTypes, (String)", ");
    }

    @JsonDeserialize(using=HalFormsDeserializers.MediaTypesDeserializer.class)
    void setContentType(List<MediaType> mediaTypes) {
        this.contentTypes = mediaTypes;
    }

    @Nullable
    String getMethod() {
        return this.httpMethod == null ? null : this.httpMethod.toString().toLowerCase();
    }

    void setMethod(String method) {
        this.httpMethod = HttpMethod.valueOf((String)method.toUpperCase());
    }

    Optional<HalFormsProperty> getPropertyByName(String name) {
        return this.properties.stream().filter(it -> it.getName().equals(name)).findFirst();
    }

    HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    List<HalFormsProperty> getProperties() {
        return this.properties;
    }

    List<MediaType> getContentTypes() {
        return this.contentTypes;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    String getTitle() {
        return this.title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HalFormsTemplate)) {
            return false;
        }
        HalFormsTemplate that = (HalFormsTemplate)o;
        return Objects.equals(this.title, that.title) && this.httpMethod == that.httpMethod && Objects.equals(this.properties, that.properties) && Objects.equals(this.contentTypes, that.contentTypes);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.httpMethod, this.properties, this.contentTypes);
    }

    public String toString() {
        return "HalFormsTemplate(title=" + this.title + ", httpMethod=" + this.httpMethod + ", properties=" + this.properties + ", contentTypes=" + this.contentTypes + ")";
    }
}

