/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.module;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvisionException;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Annotations;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.ProvisionListener;
import com.google.inject.util.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Provider;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.guice.module.BindingTypeMatcher;
import org.springframework.guice.module.GuiceAutowireCandidateResolver;
import org.springframework.guice.module.GuiceModuleMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class SpringModule
extends AbstractModule {
    public static final String SPRING_GUICE_SOURCE = "spring-guice";
    private BindingTypeMatcher matcher = new GuiceModuleMetadata();
    private Map<StageTypeKey, Provider<?>> bound = new HashMap();
    private ConfigurableListableBeanFactory beanFactory;
    private Provider<ConfigurableListableBeanFactory> beanFactoryProvider;
    private boolean enableJustInTimeBinding = true;

    public SpringModule(ApplicationContext context) {
        this(context, true);
    }

    public SpringModule(ApplicationContext context, boolean enableJustInTimeBinding) {
        this((ConfigurableListableBeanFactory)context.getAutowireCapableBeanFactory(), enableJustInTimeBinding);
    }

    public SpringModule(ConfigurableListableBeanFactory beanFactory) {
        this(beanFactory, true);
    }

    public SpringModule(ConfigurableListableBeanFactory beanFactory, boolean enableJustInTimeBinding) {
        this.beanFactory = beanFactory;
        this.enableJustInTimeBinding = enableJustInTimeBinding;
    }

    public SpringModule(Provider<ConfigurableListableBeanFactory> beanFactoryProvider) {
        this.beanFactoryProvider = beanFactoryProvider;
    }

    public void configure() {
        if (this.beanFactory == null) {
            this.beanFactory = (ConfigurableListableBeanFactory)this.beanFactoryProvider.get();
        }
        if (this.beanFactory.getBeanNamesForType(ProvisionListener.class).length > 0) {
            this.binder().bindListener(Matchers.any(), this.beanFactory.getBeansOfType(ProvisionListener.class).values().toArray(new ProvisionListener[0]));
        }
        if (this.enableJustInTimeBinding && this.beanFactory instanceof DefaultListableBeanFactory) {
            ((DefaultListableBeanFactory)this.beanFactory).setAutowireCandidateResolver((AutowireCandidateResolver)new GuiceAutowireCandidateResolver((Provider<Injector>)this.binder().getProvider(Injector.class)));
        }
        if (this.beanFactory.getBeanNamesForType(GuiceModuleMetadata.class).length > 0) {
            this.matcher = new CompositeTypeMatcher(this.beanFactory.getBeansOfType(GuiceModuleMetadata.class).values());
        }
        this.bind(this.beanFactory);
    }

    private void bind(ConfigurableListableBeanFactory beanFactory) {
        for (String name : beanFactory.getBeanDefinitionNames()) {
            Type type;
            Class clazz;
            BeanDefinition definition = beanFactory.getBeanDefinition(name);
            if (definition.hasAttribute(SPRING_GUICE_SOURCE)) continue;
            Optional<Annotation> bindingAnnotation = SpringModule.getAnnotationForBeanDefinition(definition, beanFactory);
            if (!definition.isAutowireCandidate() || definition.getRole() != 0 || (clazz = beanFactory.getType(name)) == null) continue;
            if (clazz.getTypeParameters().length > 0) {
                ParameterizedType parameterizedType;
                RootBeanDefinition rootBeanDefinition = (RootBeanDefinition)beanFactory.getMergedBeanDefinition(name);
                type = rootBeanDefinition.getFactoryBeanName() != null && rootBeanDefinition.getResolvedFactoryMethod() != null ? rootBeanDefinition.getResolvedFactoryMethod().getGenericReturnType() : rootBeanDefinition.getResolvableType().getType();
                if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() instanceof Class && FactoryBean.class.isAssignableFrom((Class)parameterizedType.getRawType())) {
                    type = Types.newParameterizedTypeWithOwner((Type)parameterizedType.getOwnerType(), (Type)clazz, (Type[])parameterizedType.getActualTypeArguments());
                }
            } else {
                type = clazz;
            }
            if (type == null) continue;
            Provider<?> typeProvider = BeanFactoryProvider.typed(beanFactory, type, bindingAnnotation);
            Provider<?> namedProvider = BeanFactoryProvider.named(beanFactory, name, type, bindingAnnotation);
            if (!clazz.isInterface() && !ClassUtils.isCglibProxyClass((Class)clazz)) {
                this.bindConditionally(this.binder(), name, clazz, typeProvider, namedProvider, bindingAnnotation);
            }
            for (Type superType : SpringModule.getAllSuperTypes(type, clazz)) {
                if (ClassUtils.isCglibProxyClassName((String)superType.getTypeName())) continue;
                this.bindConditionally(this.binder(), name, superType, typeProvider, namedProvider, bindingAnnotation);
            }
            for (Type iface : clazz.getGenericInterfaces()) {
                this.bindConditionally(this.binder(), name, iface, typeProvider, namedProvider, bindingAnnotation);
            }
        }
    }

    private static String getNameFromBindingAnnotation(Optional<Annotation> bindingAnnotation) {
        if (bindingAnnotation.isPresent()) {
            Annotation annotation = bindingAnnotation.get();
            if (annotation instanceof Named) {
                return ((Named)annotation).value();
            }
            if (annotation instanceof javax.inject.Named) {
                return ((javax.inject.Named)annotation).value();
            }
            return null;
        }
        return null;
    }

    private static Optional<Annotation> getAnnotationForBeanDefinition(BeanDefinition definition, ConfigurableListableBeanFactory beanFactory) {
        if (definition instanceof AnnotatedBeanDefinition && ((AnnotatedBeanDefinition)definition).getFactoryMethodMetadata() != null) {
            try {
                Method factoryMethod = SpringModule.getFactoryMethod(beanFactory, definition);
                return Arrays.stream(AnnotationUtils.getAnnotations((Method)factoryMethod)).filter(a -> Annotations.isBindingAnnotation(a.annotationType())).findFirst();
            }
            catch (Exception ex) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static Method getFactoryMethod(ConfigurableListableBeanFactory beanFactory, BeanDefinition definition) throws Exception {
        MethodMetadata factoryMethodMetadata;
        if (definition instanceof AnnotatedBeanDefinition && (factoryMethodMetadata = ((AnnotatedBeanDefinition)definition).getFactoryMethodMetadata()) instanceof StandardMethodMetadata) {
            return ((StandardMethodMetadata)factoryMethodMetadata).getIntrospectedMethod();
        }
        BeanDefinition factoryDefinition = beanFactory.getBeanDefinition(definition.getFactoryBeanName());
        Class factoryClass = ClassUtils.forName((String)factoryDefinition.getBeanClassName(), (ClassLoader)beanFactory.getBeanClassLoader());
        return SpringModule.getFactoryMethod(definition, factoryClass);
    }

    private static Method getFactoryMethod(BeanDefinition definition, Class<?> factoryClass) {
        Method uniqueMethod = null;
        for (Method candidate : SpringModule.getCandidateFactoryMethods(definition, factoryClass)) {
            if (!candidate.getName().equals(definition.getFactoryMethodName())) continue;
            if (uniqueMethod == null) {
                uniqueMethod = candidate;
                continue;
            }
            if (SpringModule.hasMatchingParameterTypes(candidate, uniqueMethod)) continue;
            return null;
        }
        return uniqueMethod;
    }

    private static Method[] getCandidateFactoryMethods(BeanDefinition definition, Class<?> factoryClass) {
        return SpringModule.shouldConsiderNonPublicMethods(definition) ? ReflectionUtils.getAllDeclaredMethods(factoryClass) : factoryClass.getMethods();
    }

    private static boolean shouldConsiderNonPublicMethods(BeanDefinition definition) {
        return definition instanceof AbstractBeanDefinition && ((AbstractBeanDefinition)definition).isNonPublicAccessAllowed();
    }

    private static boolean hasMatchingParameterTypes(Method candidate, Method current) {
        return Arrays.equals(candidate.getParameterTypes(), current.getParameterTypes());
    }

    private static Set<Type> getAllSuperTypes(Type originalType, Class<?> clazz) {
        HashSet<Type> allInterfaces = new HashSet<Type>();
        TypeLiteral typeToken = TypeLiteral.get((Type)originalType);
        LinkedList<Type> queue = new LinkedList<Type>();
        queue.add(clazz);
        if (originalType != clazz) {
            queue.add(originalType);
        }
        while (!queue.isEmpty()) {
            Type type = (Type)queue.poll();
            allInterfaces.add(type);
            if (!(type instanceof Class)) continue;
            for (Class<?> i : ((Class)type).getInterfaces()) {
                if (!(i instanceof Class) || !i.isAssignableFrom(typeToken.getRawType())) continue;
                Type superInterface = typeToken.getSupertype(i).getType();
                queue.add(superInterface);
                if (superInterface instanceof Class) continue;
                queue.add(i);
            }
            if (((Class)type).getSuperclass() == null || !((Class)type).isAssignableFrom(typeToken.getRawType())) continue;
            Type superClass = typeToken.getSupertype(((Class)type).getSuperclass()).getType();
            queue.add(superClass);
        }
        return allInterfaces;
    }

    private void bindConditionally(Binder binder, String name, Type type, Provider typeProvider, Provider namedProvider, Optional<Annotation> bindingAnnotation) {
        if (!this.matcher.matches(name, type)) {
            return;
        }
        if (type.getTypeName().startsWith("com.google.inject")) {
            return;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)type;
            for (Type t : param.getActualTypeArguments()) {
                if (ClassUtils.isPresent((String)t.getTypeName(), null)) continue;
                return;
            }
        }
        Key key = bindingAnnotation.map(a -> Key.get((Type)type, (Annotation)a)).orElse(Key.get((Type)type));
        StageTypeKey stageTypeKey = new StageTypeKey(binder.currentStage(), key);
        if (this.bound.get(stageTypeKey) == null) {
            binder.withSource((Object)SPRING_GUICE_SOURCE).bind(key).toProvider(typeProvider);
            this.bound.put(stageTypeKey, typeProvider);
        }
        if (!name.equals(SpringModule.getNameFromBindingAnnotation(bindingAnnotation))) {
            binder.withSource((Object)SPRING_GUICE_SOURCE).bind(TypeLiteral.get((Type)type)).annotatedWith((Annotation)Names.named((String)name)).toProvider(namedProvider);
        }
    }

    private static class CompositeTypeMatcher
    implements BindingTypeMatcher {
        private Collection<? extends BindingTypeMatcher> matchers;

        CompositeTypeMatcher(Collection<? extends BindingTypeMatcher> matchers) {
            this.matchers = matchers;
        }

        @Override
        public boolean matches(String name, Type type) {
            for (BindingTypeMatcher bindingTypeMatcher : this.matchers) {
                if (!bindingTypeMatcher.matches(name, type)) continue;
                return true;
            }
            return false;
        }
    }

    private static class BeanFactoryProvider
    implements Provider<Object> {
        private ConfigurableListableBeanFactory beanFactory;
        private String name;
        private Type type;
        private Provider<Object> resultProvider;
        private Optional<Annotation> bindingAnnotation;

        private BeanFactoryProvider(ConfigurableListableBeanFactory beanFactory, String name, Type type, Optional<Annotation> bindingAnnotation) {
            this.beanFactory = beanFactory;
            this.name = name;
            this.bindingAnnotation = bindingAnnotation;
            this.type = type;
        }

        public static Provider<?> named(ConfigurableListableBeanFactory beanFactory, String name, Type type, Optional<Annotation> bindingAnnotation) {
            return new BeanFactoryProvider(beanFactory, name, type, bindingAnnotation);
        }

        public static Provider<?> typed(ConfigurableListableBeanFactory beanFactory, Type type, Optional<Annotation> bindingAnnotation) {
            return new BeanFactoryProvider(beanFactory, null, type, bindingAnnotation);
        }

        public Object get() {
            if (this.resultProvider == null) {
                String[] named = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, (ResolvableType)ResolvableType.forType((Type)this.type));
                ArrayList<String> names = new ArrayList<String>(named.length);
                if (named.length == 1) {
                    names.add(named[0]);
                } else {
                    for (String name : named) {
                        if (this.bindingAnnotation.isPresent() && (this.bindingAnnotation.get() instanceof Named || this.bindingAnnotation.get() instanceof javax.inject.Named)) {
                            Optional annotation = SpringModule.getAnnotationForBeanDefinition(this.beanFactory.getMergedBeanDefinition(name), this.beanFactory);
                            String boundName = SpringModule.getNameFromBindingAnnotation(this.bindingAnnotation);
                            if (annotation.isPresent() && this.bindingAnnotation.get().equals(annotation.get()) || name.equals(boundName)) {
                                names.add(name);
                            }
                        }
                        if (!name.equals(this.name)) continue;
                        names.add(name);
                    }
                }
                if (names.size() == 1) {
                    this.resultProvider = () -> this.beanFactory.getBean((String)names.get(0));
                } else {
                    for (String name : named) {
                        if (!this.beanFactory.getBeanDefinition(name).isPrimary()) continue;
                        this.resultProvider = () -> this.beanFactory.getBean(name);
                        break;
                    }
                    if (this.resultProvider == null) {
                        throw new ProvisionException("No primary bean definition for type: " + this.type);
                    }
                }
            }
            return this.resultProvider.get();
        }
    }

    private static class StageTypeKey {
        private final Stage stage;
        private Key<?> key;

        StageTypeKey(Stage stage, Key<?> key) {
            this.stage = stage;
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StageTypeKey other = (StageTypeKey)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return this.stage == other.stage;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.stage == null ? 0 : this.stage.hashCode());
            return result;
        }
    }
}

