/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.annotation;

import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.Stage;
import com.google.inject.name.Named;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementSource;
import com.google.inject.spi.Elements;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.PrivateElements;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.Order;
import org.springframework.guice.annotation.GuiceFactoryBean;
import org.springframework.guice.annotation.InjectorFactory;
import org.springframework.guice.module.SpringModule;

@Configuration(proxyBeanMethods=false)
@Order(value=-2147483648)
class ModuleRegistryConfiguration
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    private static final String SPRING_GUICE_DEDUPE_BINDINGS_PROPERTY_NAME = "spring.guice.dedup";
    private static final String SPRING_GUICE_AUTOWIRE_JIT_PROPERTY_NAME = "spring.guice.autowireJIT";
    private static final String SPRING_GUICE_STAGE_PROPERTY_NAME = "spring.guice.stage";
    private final Log logger = LogFactory.getLog(this.getClass());
    private ApplicationContext applicationContext;
    private boolean enableJustInTimeBinding = true;

    ModuleRegistryConfiguration() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.enableJustInTimeBinding = (Boolean)applicationContext.getEnvironment().getProperty(SPRING_GUICE_AUTOWIRE_JIT_PROPERTY_NAME, Boolean.class, (Object)true);
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        List<Object> modules = new ArrayList(((ConfigurableListableBeanFactory)registry).getBeansOfType(Module.class).values());
        modules.add((Object)new SpringModule((ConfigurableListableBeanFactory)registry, this.enableJustInTimeBinding));
        HashMap bindings = new HashMap();
        List<Object> elements = Elements.getElements((Stage)Stage.TOOL, modules);
        if (((Boolean)this.applicationContext.getEnvironment().getProperty(SPRING_GUICE_DEDUPE_BINDINGS_PROPERTY_NAME, Boolean.class, (Object)false)).booleanValue()) {
            elements = this.removeDuplicates(elements);
            modules = Collections.singletonList(Elements.getModule(elements));
        }
        if (this.applicationContext.getEnvironment().containsProperty("spring.guice.modules.exclude")) {
            String[] modulesToFilter = this.applicationContext.getEnvironment().getProperty("spring.guice.modules.exclude", "").split(",");
            elements = elements.stream().filter(e -> this.elementFilter(modulesToFilter, (Element)e)).collect(Collectors.toList());
            modules = Collections.singletonList(Elements.getModule(elements));
        }
        for (Element e2 : elements) {
            if (e2 instanceof Binding) {
                Binding binding = (Binding)e2;
                bindings.put(binding.getKey(), binding);
                continue;
            }
            if (!(e2 instanceof PrivateElements)) continue;
            this.extractPrivateElements(bindings, (PrivateElements)e2);
        }
        this.mapBindings(bindings, registry);
        RootBeanDefinition beanDefinition = new RootBeanDefinition(GuiceInjectorInitializer.class);
        ConstructorArgumentValues args = new ConstructorArgumentValues();
        args.addIndexedArgumentValue(0, modules);
        args.addIndexedArgumentValue(1, (Object)this.applicationContext);
        beanDefinition.setConstructorArgumentValues(args);
        registry.registerBeanDefinition("guiceInjectorInitializer", (BeanDefinition)beanDefinition);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) {
    }

    private void mapBindings(Map<Key<?>, Binding<?>> bindings, BeanDefinitionRegistry registry) {
        Stage stage = (Stage)this.applicationContext.getEnvironment().getProperty(SPRING_GUICE_STAGE_PROPERTY_NAME, Stage.class, (Object)Stage.PRODUCTION);
        boolean ifLazyInit = stage.equals((Object)Stage.DEVELOPMENT);
        for (Map.Entry<Key<?>, Binding<?>> entry : bindings.entrySet()) {
            if (entry.getKey().getTypeLiteral().getRawType().equals(Injector.class) || "spring-guice".equals(Optional.ofNullable(entry.getValue().getSource()).map(Object::toString).orElse("")) || entry.getKey().getAnnotationType() != null && entry.getKey().getAnnotationType().getName().startsWith("com.google.inject.multibindings")) continue;
            Binding<?> binding = entry.getValue();
            Key<?> key = entry.getKey();
            Object source = binding.getSource();
            RootBeanDefinition bean = new RootBeanDefinition(GuiceFactoryBean.class);
            ConstructorArgumentValues args = new ConstructorArgumentValues();
            args.addIndexedArgumentValue(0, (Object)key.getTypeLiteral().getRawType());
            args.addIndexedArgumentValue(1, key);
            args.addIndexedArgumentValue(2, (Object)Scopes.isSingleton(binding));
            bean.setConstructorArgumentValues(args);
            bean.setTargetType(ResolvableType.forType((Type)key.getTypeLiteral().getType()));
            if (!Scopes.isSingleton(binding)) {
                bean.setScope("prototype");
            }
            if (source instanceof ElementSource) {
                bean.setResourceDescription(((ElementSource)source).getDeclaringSource().toString());
            } else {
                bean.setResourceDescription("spring-guice");
            }
            bean.setAttribute("spring-guice", (Object)true);
            if (key.getAnnotationType() != null) {
                bean.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)this.getValueAttributeForNamed(key)));
                bean.addQualifier(new AutowireCandidateQualifier(key.getAnnotationType(), (Object)this.getValueAttributeForNamed(key)));
            }
            if (ifLazyInit) {
                bean.setLazyInit(true);
            }
            registry.registerBeanDefinition(this.extractName(key), (BeanDefinition)bean);
        }
    }

    private String extractName(Key<?> key) {
        String className = key.getTypeLiteral().getType().getTypeName();
        String valueAttribute = this.getValueAttributeForNamed(key);
        if (valueAttribute != null) {
            return valueAttribute + "_" + className;
        }
        return className;
    }

    private String getValueAttributeForNamed(Key<?> key) {
        if (key.getAnnotation() instanceof Named) {
            return ((Named)key.getAnnotation()).value();
        }
        if (key.getAnnotation() instanceof javax.inject.Named) {
            return ((javax.inject.Named)key.getAnnotation()).value();
        }
        if (key.getAnnotationType() != null) {
            return key.getAnnotationType().getName();
        }
        return null;
    }

    private boolean elementFilter(String[] modulesToFilter, Element element) {
        try {
            return Arrays.stream(modulesToFilter).noneMatch(ex -> Optional.of(element).map(Element::getSource).map(Object::toString).orElse("").contains((CharSequence)ex));
        }
        catch (Exception ex2) {
            this.logger.error((Object)String.format("Unable fo filter element[%s] with filter [%s]", element, Arrays.toString(modulesToFilter)), (Throwable)ex2);
            return false;
        }
    }

    private void extractPrivateElements(Map<Key<?>, Binding<?>> bindings, PrivateElements privateElements) {
        List elements = privateElements.getElements();
        for (Element e : elements) {
            if (e instanceof Binding && privateElements.getExposedKeys().contains(((Binding)e).getKey())) {
                Binding binding = (Binding)e;
                bindings.put(binding.getKey(), binding);
                continue;
            }
            if (!(e instanceof PrivateElements)) continue;
            this.extractPrivateElements(bindings, (PrivateElements)e);
        }
    }

    protected List<Element> removeDuplicates(List<Element> elements) {
        List duplicateElements = elements.stream().filter(e -> e instanceof Binding).map(e -> (Binding)e).collect(Collectors.groupingBy(ModuleRegistryConfiguration::getLinkedKeyIfRequired)).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1 && ((List)e.getValue()).stream().anyMatch(binding -> binding.getSource() != null && binding.getSource().toString().contains("spring-guice"))).flatMap(e -> ((List)e.getValue()).stream()).filter(e -> e.getSource() != null && !e.getSource().toString().contains("spring-guice")).collect(Collectors.toList());
        List<Element> dedupedElements = elements.stream().filter(e -> {
            if (e instanceof Binding) {
                return !duplicateElements.contains(new SourceComparableBinding((Binding)e));
            }
            return true;
        }).collect(Collectors.toList());
        return dedupedElements;
    }

    private static Key<?> getLinkedKeyIfRequired(Binding<?> binding) {
        if (binding == null) {
            return null;
        }
        if (binding instanceof LinkedKeyBinding) {
            LinkedKeyBinding linkedBinding = (LinkedKeyBinding)binding;
            return linkedBinding.getLinkedKey();
        }
        return binding.getKey();
    }

    static class GuiceInjectorInitializer
    implements BeanPostProcessor,
    ApplicationListener<CreateInjectorEvent> {
        private final AtomicBoolean injectorCreated = new AtomicBoolean(false);
        private final List<Module> modules;
        private final ConfigurableApplicationContext applicationContext;

        GuiceInjectorInitializer(List<Module> modules, ConfigurableApplicationContext applicationContext) {
            this.modules = modules;
            this.applicationContext = applicationContext;
            applicationContext.publishEvent((ApplicationEvent)new CreateInjectorEvent());
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (this.injectorCreated.compareAndSet(false, true)) {
                this.createInjector();
            }
            return bean;
        }

        public void onApplicationEvent(CreateInjectorEvent event) {
            if (this.injectorCreated.compareAndSet(false, true)) {
                this.createInjector();
            }
        }

        private void createInjector() {
            Injector injector = null;
            try {
                Map beansOfType = this.applicationContext.getBeansOfType(InjectorFactory.class);
                if (beansOfType.size() > 1) {
                    throw new ApplicationContextException("Found multiple beans of type " + InjectorFactory.class.getName() + "  Please ensure that only one InjectorFactory bean is defined. InjectorFactory beans found: " + beansOfType.keySet());
                }
                if (beansOfType.size() == 1) {
                    InjectorFactory injectorFactory = (InjectorFactory)beansOfType.values().iterator().next();
                    injector = injectorFactory.createInjector(this.modules);
                }
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
            if (injector == null) {
                injector = Guice.createInjector(this.modules);
            }
            this.applicationContext.getBeanFactory().registerResolvableDependency(Injector.class, (Object)injector);
            this.applicationContext.getBeanFactory().registerSingleton("injector", (Object)injector);
        }

        static class CreateInjectorEvent
        extends ApplicationEvent {
            private static final long serialVersionUID = -6546970378679850504L;

            CreateInjectorEvent() {
                super((Object)-6546970378679850504L);
            }
        }
    }

    private static class SourceComparableBinding {
        private Binding<?> binding;

        SourceComparableBinding(Binding<?> binding) {
            this.binding = binding;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Binding) {
                Binding compareTo = (Binding)obj;
                if (compareTo.getSource() != null && this.binding != null) {
                    return this.binding.equals((Object)compareTo) && Objects.equals(this.binding.getSource(), compareTo.getSource());
                }
                return Objects.equals(this.binding, compareTo);
            }
            return false;
        }
    }
}

