/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.server.autoconfigure.health;

import io.grpc.BindableService;
import io.grpc.protobuf.services.HealthStatusManager;
import java.util.List;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.task.TaskSchedulingAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.grpc.server.autoconfigure.ConditionalOnGrpcServerEnabled;
import org.springframework.boot.grpc.server.autoconfigure.ConditionalOnSpringGrpc;
import org.springframework.boot.grpc.server.autoconfigure.GrpcServerFactoryAutoConfiguration;
import org.springframework.boot.grpc.server.autoconfigure.GrpcServerProperties;
import org.springframework.boot.grpc.server.autoconfigure.health.ActuatorHealthAdapter;
import org.springframework.boot.grpc.server.autoconfigure.health.ActuatorHealthAdapterInvoker;
import org.springframework.boot.health.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.health.actuate.endpoint.StatusAggregator;
import org.springframework.boot.task.SimpleAsyncTaskSchedulerBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.scheduling.annotation.EnableScheduling;

@AutoConfiguration(before={GrpcServerFactoryAutoConfiguration.class})
@ConditionalOnSpringGrpc
@ConditionalOnClass(value={HealthStatusManager.class})
@ConditionalOnGrpcServerEnabled(value="health")
@ConditionalOnBean(value={BindableService.class})
public final class GrpcServerHealthAutoConfiguration {
    @Bean(destroyMethod="enterTerminalState")
    @ConditionalOnMissingBean
    HealthStatusManager healthStatusManager() {
        return new HealthStatusManager();
    }

    @Bean
    BindableService grpcHealthService(HealthStatusManager healthStatusManager) {
        return healthStatusManager.getHealthService();
    }

    static class OnHealthIndicatorPathsCondition
    extends SpringBootCondition {
        OnHealthIndicatorPathsCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String propertyName = "spring.grpc.server.health.actuator.health-indicator-paths";
            BindResult property = Binder.get((Environment)context.getEnvironment()).bind(propertyName, Bindable.listOf(String.class));
            ConditionMessage.Builder messageBuilder = ConditionMessage.forCondition((String)"Health indicator paths (at least one)", (Object[])new Object[0]);
            if (property.isBound() && !((List)property.get()).isEmpty()) {
                return ConditionOutcome.match((ConditionMessage)messageBuilder.because("property %s found with at least one entry".formatted(propertyName)));
            }
            return ConditionOutcome.noMatch((ConditionMessage)messageBuilder.because("property %s not found with at least one entry".formatted(propertyName)));
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HealthEndpoint.class})
    @ConditionalOnAvailableEndpoint(endpoint=HealthEndpoint.class)
    @AutoConfigureAfter(value={TaskSchedulingAutoConfiguration.class}, name={"org.springframework.boot.actuate.autoconfigure.health.HealthEndpointAutoConfiguration"})
    @ConditionalOnGrpcServerEnabled(value="health.actuator")
    @Conditional(value={OnHealthIndicatorPathsCondition.class})
    @EnableConfigurationProperties(value={GrpcServerProperties.class})
    @EnableScheduling
    static class ActuatorHealthAdapterConfiguration {
        ActuatorHealthAdapterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ActuatorHealthAdapter healthAdapter(HealthStatusManager healthStatusManager, HealthEndpoint healthEndpoint, StatusAggregator statusAggregator, GrpcServerProperties serverProperties) {
            return new ActuatorHealthAdapter(healthStatusManager, healthEndpoint, statusAggregator, serverProperties.getHealth().getActuator().getUpdateOverallHealth(), serverProperties.getHealth().getActuator().getHealthIndicatorPaths());
        }

        @Bean
        ActuatorHealthAdapterInvoker healthAdapterInvoker(ActuatorHealthAdapter healthAdapter, SimpleAsyncTaskSchedulerBuilder schedulerBuilder, GrpcServerProperties serverProperties) {
            return new ActuatorHealthAdapterInvoker(healthAdapter, schedulerBuilder, serverProperties.getHealth().getActuator().getUpdateInitialDelay(), serverProperties.getHealth().getActuator().getUpdateRate());
        }
    }
}

