/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.server.autoconfigure;

import io.grpc.servlet.jakarta.GrpcServlet;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.ConfigurationCondition;

class OnGrpcNativeServerCondition
extends AnyNestedCondition {
    OnGrpcNativeServerCondition() {
        super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
    }

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class OnExplicitlyDisabledWebflux {
        OnExplicitlyDisabledWebflux() {
        }
    }

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={GrpcServlet.class})
    @ConditionalOnProperty(prefix="spring.grpc.server", name={"servlet.enabled"}, havingValue="false")
    static class OnExplicitlyDisabledServlet {
        OnExplicitlyDisabledServlet() {
        }
    }

    @ConditionalOnMissingClass(value={"io.grpc.servlet.jakarta.GrpcServlet"})
    static class OnGrpcServletClass {
        OnGrpcServletClass() {
        }
    }

    @ConditionalOnNotWebApplication
    static class OnNonWebApplication {
        OnNonWebApplication() {
        }
    }
}

