/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.server.autoconfigure;

import io.micrometer.core.instrument.binder.grpc.ObservationGrpcServerInterceptor;
import io.micrometer.core.instrument.kotlin.ObservationCoroutineContextServerInterceptor;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.grpc.server.autoconfigure.ConditionalOnGrpcServerEnabled;
import org.springframework.boot.grpc.server.autoconfigure.ConditionalOnSpringGrpc;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.grpc.server.GlobalServerInterceptor;

@AutoConfiguration(afterName={"org.springframework.boot.micrometer.observation.autoconfigure.ObservationAutoConfiguration"})
@ConditionalOnSpringGrpc
@ConditionalOnClass(value={ObservationRegistry.class, ObservationGrpcServerInterceptor.class})
@ConditionalOnGrpcServerEnabled(value="observation")
@ConditionalOnBean(value={ObservationRegistry.class})
public final class GrpcServerObservationAutoConfiguration {
    @Bean
    @Order(value=0)
    @GlobalServerInterceptor
    ObservationGrpcServerInterceptor observationGrpcServerInterceptor(ObservationRegistry observationRegistry) {
        return new ObservationGrpcServerInterceptor(observationRegistry);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"io.grpc.kotlin.AbstractCoroutineStub", "io.micrometer.context.ContextRegistry"})
    static class GrpcServerCoroutineStubConfiguration {
        GrpcServerCoroutineStubConfiguration() {
        }

        @Bean
        @Order(value=10)
        @GlobalServerInterceptor
        ObservationCoroutineContextServerInterceptor observationCoroutineGrpcServerInterceptor(ObservationRegistry observationRegistry) {
            return new ObservationCoroutineContextServerInterceptor(observationRegistry);
        }
    }
}

