/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webflux;

import graphql.GraphQLError;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.graphql.server.support.GraphQlWebSocketMessage;
import org.springframework.http.MediaType;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;

final class WebSocketCodecDelegate {
    private static final ResolvableType MESSAGE_TYPE = ResolvableType.forClass(GraphQlWebSocketMessage.class);
    private final Decoder<?> decoder;
    private final Encoder<?> encoder;
    private boolean messagesEncoded;

    WebSocketCodecDelegate(CodecConfigurer codecConfigurer) {
        Assert.notNull((Object)codecConfigurer, (String)"CodecConfigurer is required");
        this.decoder = WebSocketCodecDelegate.findJsonDecoder(codecConfigurer);
        this.encoder = WebSocketCodecDelegate.findJsonEncoder(codecConfigurer);
    }

    private static Decoder<?> findJsonDecoder(CodecConfigurer configurer) {
        return configurer.getReaders().stream().filter(reader -> reader.canRead(MESSAGE_TYPE, MediaType.APPLICATION_JSON)).map(reader -> ((DecoderHttpMessageReader)reader).getDecoder()).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Decoder"));
    }

    private static Encoder<?> findJsonEncoder(CodecConfigurer configurer) {
        return configurer.getWriters().stream().filter(writer -> writer.canWrite(MESSAGE_TYPE, MediaType.APPLICATION_JSON)).map(writer -> ((EncoderHttpMessageWriter)writer).getEncoder()).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Encoder"));
    }

    <T> WebSocketMessage encode(WebSocketSession session, GraphQlWebSocketMessage message) {
        DataBuffer buffer = this.encoder.encodeValue((Object)message, session.bufferFactory(), MESSAGE_TYPE, MimeTypeUtils.APPLICATION_JSON, null);
        this.messagesEncoded = true;
        return new WebSocketMessage(WebSocketMessage.Type.TEXT, buffer);
    }

    @Nullable GraphQlWebSocketMessage decode(WebSocketMessage webSocketMessage) {
        DataBuffer buffer = DataBufferUtils.retain((DataBuffer)webSocketMessage.getPayload());
        return (GraphQlWebSocketMessage)this.decoder.decode(buffer, MESSAGE_TYPE, null, null);
    }

    WebSocketMessage encodeConnectionAck(WebSocketSession session, Object ackPayload) {
        return this.encode(session, GraphQlWebSocketMessage.connectionAck(ackPayload));
    }

    WebSocketMessage encodeNext(WebSocketSession session, String id, Map<String, Object> responseMap) {
        return this.encode(session, GraphQlWebSocketMessage.next(id, responseMap));
    }

    WebSocketMessage encodeError(WebSocketSession session, String id, List<GraphQLError> errors) {
        return this.encode(session, GraphQlWebSocketMessage.error(id, errors));
    }

    WebSocketMessage encodeComplete(WebSocketSession session, String id) {
        return this.encode(session, GraphQlWebSocketMessage.complete(id));
    }

    boolean checkMessagesEncodedAndClear() {
        boolean result = this.messagesEncoded;
        this.messagesEncoded = false;
        return result;
    }
}

