/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.ClassPathResource;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.MediaTypes;
import org.springframework.graphql.client.DefaultClientGraphQlResponse;
import org.springframework.graphql.client.DefaultGraphQlClient;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.graphql.client.GraphQlClientInterceptor;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.graphql.client.json.GraphQlJackson2Module;
import org.springframework.graphql.client.json.GraphQlJacksonModule;
import org.springframework.graphql.support.CachingDocumentSource;
import org.springframework.graphql.support.DocumentSource;
import org.springframework.graphql.support.ResourceDocumentSource;
import org.springframework.http.MediaType;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.json.JacksonJsonDecoder;
import org.springframework.http.codec.json.JacksonJsonEncoder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.json.JsonMapper;

public abstract class AbstractGraphQlClientBuilder<B extends AbstractGraphQlClientBuilder<B>>
implements GraphQlClient.Builder<B> {
    protected static final boolean jacksonPresent = ClassUtils.isPresent((String)"tools.jackson.databind.ObjectMapper", (ClassLoader)AbstractGraphQlClientBuilder.class.getClassLoader());
    protected static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)AbstractGraphQlClientBuilder.class.getClassLoader());
    private final List<GraphQlClientInterceptor> interceptors = new ArrayList<GraphQlClientInterceptor>();
    private DocumentSource documentSource = AbstractGraphQlClientBuilder.initDocumentSource();
    private @Nullable Encoder<?> jsonEncoder;
    private @Nullable Decoder<?> jsonDecoder;
    private @Nullable Duration blockingTimeout;

    protected AbstractGraphQlClientBuilder() {
    }

    private static DocumentSource initDocumentSource() {
        return new CachingDocumentSource(new ResourceDocumentSource(Collections.singletonList(new ClassPathResource("graphql-documents/")), ResourceDocumentSource.FILE_EXTENSIONS));
    }

    @Override
    public B interceptor(GraphQlClientInterceptor ... interceptors) {
        this.interceptors.addAll(Arrays.asList(interceptors));
        return (B)this.self();
    }

    @Override
    public B interceptors(Consumer<List<GraphQlClientInterceptor>> interceptorsConsumer) {
        interceptorsConsumer.accept(this.interceptors);
        return (B)this.self();
    }

    @Override
    public B documentSource(DocumentSource documentSource) {
        this.documentSource = documentSource;
        return (B)this.self();
    }

    @Override
    public B blockingTimeout(@Nullable Duration blockingTimeout) {
        this.blockingTimeout = blockingTimeout;
        return (B)this.self();
    }

    private <T extends B> T self() {
        return (T)this;
    }

    protected void setJsonCodecs(Encoder<?> encoder, Decoder<?> decoder) {
        this.jsonEncoder = encoder;
        this.jsonDecoder = decoder;
    }

    protected void setJsonEncoder(Encoder<?> encoder) {
        this.jsonEncoder = encoder;
    }

    protected Encoder<?> getJsonEncoder() {
        Assert.notNull(this.jsonEncoder, (String)"JSON Encoder not set");
        return this.jsonEncoder;
    }

    protected void setJsonDecoder(Decoder<?> decoder) {
        this.jsonDecoder = decoder;
    }

    protected Decoder<?> getJsonDecoder() {
        Assert.notNull(this.jsonDecoder, (String)"JSON Encoder not set");
        return this.jsonDecoder;
    }

    protected List<GraphQlClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    protected GraphQlClient buildGraphQlClient(GraphQlTransport transport) {
        if (jacksonPresent) {
            this.jsonEncoder = this.jsonEncoder == null ? DefaultJacksonCodecs.encoder() : this.jsonEncoder;
            this.jsonDecoder = this.jsonDecoder == null ? DefaultJacksonCodecs.decoder() : this.jsonDecoder;
        } else if (jackson2Present) {
            this.jsonEncoder = this.jsonEncoder == null ? DefaultJackson2Codecs.encoder() : this.jsonEncoder;
            this.jsonDecoder = this.jsonDecoder == null ? DefaultJackson2Codecs.decoder() : this.jsonDecoder;
        }
        return new DefaultGraphQlClient(this.documentSource, this.createExecuteChain(transport), this.createSubscriptionChain(transport), this.blockingTimeout);
    }

    protected Consumer<AbstractGraphQlClientBuilder<?>> getBuilderInitializer() {
        return builder -> {
            builder.interceptors((T interceptorList) -> interceptorList.addAll(this.interceptors));
            builder.documentSource(this.documentSource);
            builder.setJsonCodecs(this.getEncoder(), this.getDecoder());
        };
    }

    private GraphQlClientInterceptor.Chain createExecuteChain(GraphQlTransport transport) {
        GraphQlClientInterceptor.Chain chain = request -> transport.execute(request).map(response -> new DefaultClientGraphQlResponse(request, (GraphQlResponse)response, this.getEncoder(), this.getDecoder()));
        return this.interceptors.stream().reduce(GraphQlClientInterceptor::andThen).map(i -> request -> i.intercept(request, chain)).orElse(chain);
    }

    private GraphQlClientInterceptor.SubscriptionChain createSubscriptionChain(GraphQlTransport transport) {
        GraphQlClientInterceptor.SubscriptionChain chain = request -> transport.executeSubscription(request).map(response -> new DefaultClientGraphQlResponse(request, (GraphQlResponse)response, this.getEncoder(), this.getDecoder()));
        return this.interceptors.stream().reduce(GraphQlClientInterceptor::andThen).map(i -> request -> i.interceptSubscription(request, chain)).orElse(chain);
    }

    private Encoder<?> getEncoder() {
        Assert.notNull(this.jsonEncoder, (String)"jsonEncoder has not been set");
        return this.jsonEncoder;
    }

    private Decoder<?> getDecoder() {
        Assert.notNull(this.jsonDecoder, (String)"jsonDecoder has not been set");
        return this.jsonDecoder;
    }

    protected static class DefaultJacksonCodecs {
        private static final JsonMapper JSON_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().addModule((JacksonModule)new GraphQlJacksonModule())).build();

        protected DefaultJacksonCodecs() {
        }

        static Encoder<?> encoder() {
            return new JacksonJsonEncoder(JSON_MAPPER, new MimeType[]{MediaType.APPLICATION_JSON});
        }

        static Decoder<?> decoder() {
            return new JacksonJsonDecoder(JSON_MAPPER, new MimeType[]{MediaType.APPLICATION_JSON, MediaTypes.APPLICATION_GRAPHQL_RESPONSE});
        }
    }

    protected static class DefaultJackson2Codecs {
        private static final ObjectMapper JSON_MAPPER = Jackson2ObjectMapperBuilder.json().modulesToInstall(new Module[]{new GraphQlJackson2Module()}).build();

        protected DefaultJackson2Codecs() {
        }

        static Encoder<?> encoder() {
            return new Jackson2JsonEncoder(JSON_MAPPER, new MimeType[]{MediaType.APPLICATION_JSON});
        }

        static Decoder<?> decoder() {
            return new Jackson2JsonDecoder(JSON_MAPPER, new MimeType[]{MediaType.APPLICATION_JSON, MediaTypes.APPLICATION_GRAPHQL_RESPONSE});
        }
    }
}

