/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server;

import java.time.Duration;
import org.springframework.graphql.server.WebGraphQlInterceptor;
import org.springframework.graphql.server.WebGraphQlRequest;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Mono;

public class TimeoutWebGraphQlInterceptor
implements WebGraphQlInterceptor {
    private final Duration timeout;
    private final HttpStatus timeoutStatus;

    public TimeoutWebGraphQlInterceptor(Duration timeout) {
        this(timeout, HttpStatus.REQUEST_TIMEOUT);
    }

    public TimeoutWebGraphQlInterceptor(Duration timeout, HttpStatus timeoutStatus) {
        this.timeout = timeout;
        this.timeoutStatus = timeoutStatus;
    }

    @Override
    public Mono<WebGraphQlResponse> intercept(WebGraphQlRequest request, WebGraphQlInterceptor.Chain chain) {
        return chain.next(request).timeout(this.timeout, Mono.error((Throwable)new ResponseStatusException((HttpStatusCode)this.timeoutStatus)));
    }
}

