/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import java.util.function.Consumer;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.graphql.test.tester.AbstractDelegatingGraphQlTester;
import org.springframework.graphql.test.tester.AbstractGraphQlTesterBuilder;
import org.springframework.graphql.test.tester.GraphQlTester;
import org.springframework.util.Assert;

final class DefaultTransportGraphQlTesterBuilder
extends AbstractGraphQlTesterBuilder<DefaultTransportGraphQlTesterBuilder> {
    private final GraphQlTransport transport;

    DefaultTransportGraphQlTesterBuilder(GraphQlTransport transport) {
        this.transport = transport;
    }

    @Override
    public GraphQlTester build() {
        GraphQlTester tester = super.buildGraphQlTester(this.transport);
        return new DefaultTransportGraphQlTester(tester, this.transport, this.getBuilderInitializer());
    }

    private static class DefaultTransportGraphQlTester
    extends AbstractDelegatingGraphQlTester {
        private final GraphQlTransport transport;
        private final Consumer<AbstractGraphQlTesterBuilder<?>> builderInitializer;

        private DefaultTransportGraphQlTester(GraphQlTester delegate, GraphQlTransport transport, Consumer<AbstractGraphQlTesterBuilder<?>> builderInitializer) {
            super(delegate);
            Assert.notNull((Object)transport, (String)"GraphQlTransport is required");
            Assert.notNull(builderInitializer, (String)"'builderInitializer' is required");
            this.transport = transport;
            this.builderInitializer = builderInitializer;
        }

        public DefaultTransportGraphQlTesterBuilder mutate() {
            DefaultTransportGraphQlTesterBuilder builder = new DefaultTransportGraphQlTesterBuilder(this.transport);
            this.builderInitializer.accept(builder);
            return builder;
        }
    }
}

