/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.From;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.Where;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.FromClauseVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.WhereClauseVisitor;

class DeleteStatementVisitor
extends DelegatingVisitor
implements PartRenderer {
    private final StringBuilder builder = new StringBuilder();
    private final StringBuilder from = new StringBuilder();
    private final StringBuilder where = new StringBuilder();
    private final FromClauseVisitor fromClauseVisitor;
    private final WhereClauseVisitor whereClauseVisitor;

    DeleteStatementVisitor(RenderContext context) {
        this.fromClauseVisitor = new FromClauseVisitor(context, it -> {
            if (!this.from.isEmpty()) {
                this.from.append(", ");
            }
            this.from.append(it);
        });
        this.whereClauseVisitor = new WhereClauseVisitor(context, this.where::append);
    }

    @Override
    public DelegatingVisitor.Delegation doEnter(Visitable segment) {
        if (segment instanceof From) {
            return DelegatingVisitor.Delegation.delegateTo(this.fromClauseVisitor);
        }
        if (segment instanceof Where) {
            return DelegatingVisitor.Delegation.delegateTo(this.whereClauseVisitor);
        }
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    public DelegatingVisitor.Delegation doLeave(Visitable segment) {
        if (segment instanceof Delete) {
            this.builder.append("DELETE ");
            if (!this.from.isEmpty()) {
                this.builder.append("FROM ").append((CharSequence)this.from);
            }
            if (!this.where.isEmpty()) {
                this.builder.append(" WHERE ").append((CharSequence)this.where);
            }
            return DelegatingVisitor.Delegation.leave();
        }
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.builder;
    }
}

