/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.FallbackExceptionTranslationStrategy;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.AbstractRedisConnection;
import org.springframework.data.redis.connection.FutureResult;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisCommands;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.convert.TransactionResultConverter;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisExceptionConverter;
import org.springframework.data.redis.connection.jedis.JedisGeoCommands;
import org.springframework.data.redis.connection.jedis.JedisHashCommands;
import org.springframework.data.redis.connection.jedis.JedisHyperLogLogCommands;
import org.springframework.data.redis.connection.jedis.JedisInvoker;
import org.springframework.data.redis.connection.jedis.JedisKeyCommands;
import org.springframework.data.redis.connection.jedis.JedisListCommands;
import org.springframework.data.redis.connection.jedis.JedisMessageListener;
import org.springframework.data.redis.connection.jedis.JedisResult;
import org.springframework.data.redis.connection.jedis.JedisScriptingCommands;
import org.springframework.data.redis.connection.jedis.JedisSentinelConnection;
import org.springframework.data.redis.connection.jedis.JedisServerCommands;
import org.springframework.data.redis.connection.jedis.JedisSetCommands;
import org.springframework.data.redis.connection.jedis.JedisStreamCommands;
import org.springframework.data.redis.connection.jedis.JedisStringCommands;
import org.springframework.data.redis.connection.jedis.JedisSubscription;
import org.springframework.data.redis.connection.jedis.JedisZSetCommands;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.commands.ServerCommands;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.util.Pool;

@NullUnmarked
public class JedisConnection
extends AbstractRedisConnection {
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new FallbackExceptionTranslationStrategy(JedisExceptionConverter.INSTANCE);
    private boolean convertPipelineAndTxResults = true;
    private final Jedis jedis;
    private final JedisClientConfig sentinelConfig;
    private final JedisInvoker invoker = new JedisInvoker((directFunction, pipelineFunction, converter, nullDefault) -> this.doInvoke(false, directFunction, pipelineFunction, (Converter<Object, Object>)converter, nullDefault));
    private final JedisInvoker statusInvoker = new JedisInvoker((directFunction, pipelineFunction, converter, nullDefault) -> this.doInvoke(true, directFunction, pipelineFunction, (Converter<Object, Object>)converter, nullDefault));
    private volatile @Nullable JedisSubscription subscription;
    private final JedisGeoCommands geoCommands = new JedisGeoCommands(this);
    private final JedisHashCommands hashCommands = new JedisHashCommands(this);
    private final JedisHyperLogLogCommands hllCommands = new JedisHyperLogLogCommands(this);
    private final JedisKeyCommands keyCommands = new JedisKeyCommands(this);
    private final JedisListCommands listCommands = new JedisListCommands(this);
    private final JedisScriptingCommands scriptingCommands = new JedisScriptingCommands(this);
    private final JedisServerCommands serverCommands = new JedisServerCommands(this);
    private final JedisSetCommands setCommands = new JedisSetCommands(this);
    private final JedisStreamCommands streamCommands = new JedisStreamCommands(this);
    private final JedisStringCommands stringCommands = new JedisStringCommands(this);
    private final JedisZSetCommands zSetCommands = new JedisZSetCommands(this);
    private final Log LOGGER = LogFactory.getLog(this.getClass());
    private List<JedisResult> pipelinedResults = new ArrayList<JedisResult>();
    private final @Nullable Pool<Jedis> pool;
    private Queue<FutureResult<Response<?>>> txResults = new LinkedList();
    private volatile @Nullable Pipeline pipeline;
    private volatile @Nullable Transaction transaction;

    public JedisConnection(@NonNull Jedis jedis) {
        this(jedis, null, 0);
    }

    public JedisConnection(@NonNull Jedis jedis, @Nullable Pool<Jedis> pool, int dbIndex) {
        this(jedis, pool, dbIndex, null);
    }

    protected JedisConnection(@NonNull Jedis jedis, @Nullable Pool<Jedis> pool, int dbIndex, @Nullable String clientName) {
        this(jedis, pool, (JedisClientConfig)JedisConnection.createConfig(dbIndex, clientName), (JedisClientConfig)JedisConnection.createConfig(dbIndex, clientName));
    }

    protected JedisConnection(@NonNull Jedis jedis, @Nullable Pool<Jedis> pool, @NonNull JedisClientConfig nodeConfig, @NonNull JedisClientConfig sentinelConfig) {
        this.jedis = jedis;
        this.pool = pool;
        this.sentinelConfig = sentinelConfig;
        if (nodeConfig.getDatabase() != jedis.getDB()) {
            try {
                this.select(nodeConfig.getDatabase());
            }
            catch (DataAccessException ex) {
                this.close();
                throw ex;
            }
        }
    }

    private static DefaultJedisClientConfig createConfig(int dbIndex, @Nullable String clientName) {
        return DefaultJedisClientConfig.builder().database(dbIndex).clientName(clientName).build();
    }

    private @Nullable Object doInvoke(boolean status, Function<Jedis, Object> directFunction, Function<JedisInvoker.ResponseCommands, Response<Object>> pipelineFunction, Converter<Object, Object> converter, Supplier<Object> nullDefault) {
        return this.doWithJedis((Jedis it) -> {
            if (this.isQueueing()) {
                Response response = (Response)pipelineFunction.apply(JedisInvoker.createCommands(this.getRequiredTransaction()));
                this.transaction(status ? this.newStatusResult(response) : this.newJedisResult(response, converter, nullDefault));
                return null;
            }
            if (this.isPipelined()) {
                Response response = (Response)pipelineFunction.apply(JedisInvoker.createCommands(this.getRequiredPipeline()));
                this.pipeline(status ? this.newStatusResult(response) : this.newJedisResult(response, converter, nullDefault));
                return null;
            }
            Object result = directFunction.apply(this.getJedis());
            if (result == null) {
                return nullDefault.get();
            }
            return converter.convert(result);
        });
    }

    protected DataAccessException convertJedisAccessException(Exception cause) {
        DataAccessException exception = EXCEPTION_TRANSLATION.translate(cause);
        return exception != null ? exception : new RedisSystemException(cause.getMessage(), cause);
    }

    @Override
    public RedisCommands commands() {
        return this;
    }

    @Override
    public RedisGeoCommands geoCommands() {
        return this.geoCommands;
    }

    @Override
    public RedisHashCommands hashCommands() {
        return this.hashCommands;
    }

    @Override
    public RedisHyperLogLogCommands hyperLogLogCommands() {
        return this.hllCommands;
    }

    @Override
    public RedisKeyCommands keyCommands() {
        return this.keyCommands;
    }

    @Override
    public RedisListCommands listCommands() {
        return this.listCommands;
    }

    @Override
    public RedisSetCommands setCommands() {
        return this.setCommands;
    }

    @Override
    public RedisStreamCommands streamCommands() {
        return this.streamCommands;
    }

    @Override
    public RedisStringCommands stringCommands() {
        return this.stringCommands;
    }

    @Override
    public RedisZSetCommands zSetCommands() {
        return this.zSetCommands;
    }

    @Override
    public RedisScriptingCommands scriptingCommands() {
        return this.scriptingCommands;
    }

    @Override
    public RedisServerCommands serverCommands() {
        return this.serverCommands;
    }

    @Override
    public Object execute(@NonNull String command, byte[] ... args) {
        Assert.hasText((String)command, (String)"A valid command needs to be specified");
        Assert.notNull((Object)args, (String)"Arguments must not be null");
        return this.doWithJedis((Jedis it) -> {
            ProtocolCommand protocolCommand = () -> JedisConverters.toBytes(command);
            if (this.isQueueing() || this.isPipelined()) {
                CommandArguments arguments = new CommandArguments(protocolCommand).addObjects((Object[])args);
                CommandObject commandObject = new CommandObject(arguments, BuilderFactory.RAW_OBJECT);
                if (this.isPipelined()) {
                    this.pipeline(this.newJedisResult(this.getRequiredPipeline().executeCommand(commandObject)));
                } else {
                    this.transaction(this.newJedisResult(this.getRequiredTransaction().executeCommand(commandObject)));
                }
                return null;
            }
            return it.sendCommand(protocolCommand, args);
        });
    }

    @Override
    public void close() throws DataAccessException {
        super.close();
        JedisSubscription subscription = this.subscription;
        if (subscription != null) {
            this.doExceptionThrowingOperationSafely(subscription::close, "Cannot terminate subscription");
            this.subscription = null;
        }
        Jedis jedis = this.getJedis();
        if (this.pool != null) {
            jedis.close();
        } else {
            this.doExceptionThrowingOperationSafely(() -> ((Jedis)jedis).disconnect(), "Failed to disconnect during close");
        }
    }

    public Jedis getNativeConnection() {
        return this.jedis;
    }

    @Override
    public boolean isClosed() {
        return !Boolean.TRUE.equals(this.doWithJedis(Jedis::isConnected));
    }

    @Override
    public boolean isQueueing() {
        return this.transaction != null;
    }

    @Override
    public boolean isPipelined() {
        return this.pipeline != null;
    }

    @Override
    public void openPipeline() {
        if (this.isQueueing()) {
            throw new InvalidDataAccessApiUsageException("Cannot use Pipelining while a transaction is active");
        }
        if (this.pipeline == null) {
            this.pipeline = this.jedis.pipelined();
        }
    }

    @Override
    public List<@Nullable Object> closePipeline() {
        if (this.pipeline != null) {
            try {
                List<Object> list = this.convertPipelineResults();
                return list;
            }
            finally {
                this.pipeline = null;
                this.pipelinedResults.clear();
            }
        }
        return Collections.emptyList();
    }

    private List<@Nullable Object> convertPipelineResults() {
        ArrayList<Object> results = new ArrayList<Object>();
        this.getRequiredPipeline().sync();
        DataAccessException cause = null;
        for (JedisResult result : this.pipelinedResults) {
            try {
                Object data = result.get();
                if (result.isStatus()) continue;
                results.add(result.conversionRequired() ? result.convert(data) : data);
            }
            catch (JedisDataException ex) {
                DataAccessException dataAccessException = this.convertJedisAccessException((Exception)((Object)ex));
                if (cause == null) {
                    cause = dataAccessException;
                }
                results.add((Object)dataAccessException);
            }
            catch (DataAccessException ex) {
                if (cause == null) {
                    cause = ex;
                }
                results.add((Object)ex);
            }
        }
        if (cause != null) {
            throw new RedisPipelineException((Exception)((Object)cause), (List<Object>)results);
        }
        return results;
    }

    void pipeline(@NonNull JedisResult<?, ?> result) {
        if (this.isQueueing()) {
            this.transaction(result);
        } else {
            this.pipelinedResults.add(result);
        }
    }

    void transaction(@NonNull FutureResult<Response<?>> result) {
        this.txResults.add(result);
    }

    @Override
    public byte[] echo(byte @NonNull [] message) {
        Assert.notNull((Object)message, (String)"Message must not be null");
        return this.invoke().just(jedis -> jedis.echo(message));
    }

    @Override
    public String ping() {
        return this.invoke().just(ServerCommands::ping);
    }

    @Override
    public void discard() {
        try {
            this.getRequiredTransaction().discard();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
        finally {
            this.txResults.clear();
            this.transaction = null;
        }
    }

    @Override
    public List<@Nullable Object> exec() {
        try {
            if (this.transaction == null) {
                throw new InvalidDataAccessApiUsageException("No ongoing transaction; Did you forget to call multi");
            }
            List<Object> results = this.transaction.exec();
            List<Object> list = !CollectionUtils.isEmpty((Collection)results) ? new TransactionResultConverter(this.txResults, JedisExceptionConverter.INSTANCE).convert(results) : results;
            return list;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
        finally {
            this.txResults.clear();
            this.transaction = null;
        }
    }

    public @Nullable Pipeline getPipeline() {
        return this.pipeline;
    }

    public Pipeline getRequiredPipeline() {
        Pipeline pipeline = this.getPipeline();
        Assert.state((pipeline != null ? 1 : 0) != 0, (String)"Connection has no active pipeline");
        return pipeline;
    }

    public @Nullable Transaction getTransaction() {
        return this.transaction;
    }

    public Transaction getRequiredTransaction() {
        Transaction transaction = this.getTransaction();
        Assert.state((transaction != null ? 1 : 0) != 0, (String)"Connection has no active transaction");
        return transaction;
    }

    public @NonNull Jedis getJedis() {
        return this.jedis;
    }

    @NonNull JedisInvoker invoke() {
        return this.invoker;
    }

    @NonNull JedisInvoker invokeStatus() {
        return this.statusInvoker;
    }

    <T> JedisResult<T, T> newJedisResult(Response<T> response) {
        return JedisResult.JedisResultBuilder.forResponse(response).build();
    }

    <T, R> JedisResult<T, R> newJedisResult(Response<T> response, Converter<T, R> converter, Supplier<R> defaultValue) {
        return JedisResult.JedisResultBuilder.forResponse(response).mappedWith(converter).convertPipelineAndTxResults(this.convertPipelineAndTxResults).mapNullTo(defaultValue).build();
    }

    <T> JedisResult.JedisStatusResult<T, T> newStatusResult(Response<T> response) {
        return JedisResult.JedisResultBuilder.forResponse(response).buildStatusResult();
    }

    @Override
    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        if (this.isPipelined()) {
            throw new InvalidDataAccessApiUsageException("Cannot use Transaction while a pipeline is open");
        }
        this.doWithJedis((Jedis jedis) -> {
            this.transaction = jedis.multi();
        });
    }

    @Override
    public void select(int dbIndex) {
        this.getJedis().select(dbIndex);
    }

    @Override
    public void unwatch() {
        this.doWithJedis(Jedis::unwatch);
    }

    @Override
    public void watch(byte[] ... keys) {
        if (this.isQueueing()) {
            throw new InvalidDataAccessApiUsageException("WATCH is not supported when a transaction is active");
        }
        this.doWithJedis((Jedis jedis) -> {
            for (byte[] key : keys) {
                jedis.watch((byte[][])new byte[][]{key});
            }
        });
    }

    @Override
    public Long publish(byte @NonNull [] channel, byte @NonNull [] message) {
        return this.invoke().just(jedis -> jedis.publish(channel, message));
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isSubscribed() {
        Subscription subscription = this.getSubscription();
        return subscription != null && subscription.isAlive();
    }

    @Override
    public void pSubscribe(@NonNull MessageListener listener, byte[] ... patterns) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        if (this.isQueueing() || this.isPipelined()) {
            throw new InvalidDataAccessApiUsageException("Cannot subscribe in pipeline / transaction mode");
        }
        this.doWithJedis((Jedis it) -> {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, null, patterns);
            it.psubscribe((BinaryJedisPubSub)jedisPubSub, patterns);
        });
    }

    @Override
    public void subscribe(@NonNull MessageListener listener, byte[] ... channels) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        if (this.isQueueing() || this.isPipelined()) {
            throw new InvalidDataAccessApiUsageException("Cannot subscribe in pipeline / transaction mode");
        }
        this.doWithJedis((Jedis it) -> {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, channels, null);
            it.subscribe((BinaryJedisPubSub)jedisPubSub, channels);
        });
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isActive(@NonNull RedisNode node) {
        Jedis verification = null;
        try {
            verification = this.getJedis(node);
            verification.connect();
            boolean bl = verification.ping().equalsIgnoreCase("pong");
            return bl;
        }
        catch (Exception ignore) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (verification != null) {
                verification.disconnect();
                verification.close();
            }
        }
    }

    @Override
    protected JedisSentinelConnection getSentinelConnection(@NonNull RedisNode sentinel) {
        return new JedisSentinelConnection(this.getJedis(sentinel));
    }

    protected Jedis getJedis(@NonNull RedisNode node) {
        return new Jedis(JedisConverters.toHostAndPort(node), this.sentinelConfig);
    }

    private <T> @Nullable T doWithJedis(@NonNull Function<@NonNull Jedis, T> callback) {
        try {
            return callback.apply(this.getJedis());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private void doWithJedis(@NonNull Consumer<@NonNull Jedis> callback) {
        try {
            callback.accept(this.getJedis());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private void doExceptionThrowingOperationSafely(ExceptionThrowingOperation operation, String logMessage) {
        block2: {
            try {
                operation.run();
            }
            catch (Exception ex) {
                if (!this.LOGGER.isDebugEnabled()) break block2;
                this.LOGGER.debug((Object)logMessage, (Throwable)ex);
            }
        }
    }

    @FunctionalInterface
    private static interface ExceptionThrowingOperation {
        public void run() throws Exception;
    }
}

