/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.serializer.ByteArrayRedisSerializer;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.ClassUtils;

public interface RedisSerializer<T> {
    public static RedisSerializer<Object> java() {
        return RedisSerializer.java(null);
    }

    public static RedisSerializer<Object> java(@Nullable ClassLoader classLoader) {
        return new JdkSerializationRedisSerializer(classLoader);
    }

    public static RedisSerializer<Object> json() {
        return new GenericJackson2JsonRedisSerializer();
    }

    public static RedisSerializer<String> string() {
        return StringRedisSerializer.UTF_8;
    }

    public static RedisSerializer<byte[]> byteArray() {
        return ByteArrayRedisSerializer.INSTANCE;
    }

    public byte[] serialize(@Nullable T var1) throws SerializationException;

    public @Nullable T deserialize(byte @Nullable [] var1) throws SerializationException;

    default public boolean canSerialize(Class<?> type) {
        return ClassUtils.isAssignable(this.getTargetType(), type);
    }

    default public Class<?> getTargetType() {
        return Object.class;
    }
}

