/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.StringJoiner;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.StringUtils;

public class KeyScanOptions
extends ScanOptions {
    public static KeyScanOptions NONE = new KeyScanOptions(null, null, null, null);
    private final @Nullable String type;

    KeyScanOptions(@Nullable Long count, @Nullable String pattern, byte @Nullable [] bytePattern, @Nullable String type) {
        super(count, pattern, bytePattern);
        this.type = type;
    }

    public static ScanOptions.ScanOptionsBuilder scanOptions(DataType type) {
        return new ScanOptions.ScanOptionsBuilder().type(type);
    }

    public @Nullable String getType() {
        return this.type;
    }

    @Override
    public String toOptionString() {
        if (this.equals(NONE)) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(", ").add(super.toOptionString());
        if (StringUtils.hasText((String)this.type)) {
            joiner.add("'type' '" + this.type + "'");
        }
        return joiner.toString();
    }
}

