/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.core.BoundHashFieldExpirationOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.DefaultBoundHashFieldExpirationOperations;
import org.springframework.data.redis.core.ExpireChanges;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.Expirations;

@NullUnmarked
public interface HashOperations<H, HK, HV> {
    public Long delete(@NonNull H var1, Object ... var2);

    public Boolean hasKey(@NonNull H var1, @NonNull Object var2);

    public HV get(@NonNull H var1, @NonNull Object var2);

    public List<HV> multiGet(@NonNull H var1, @NonNull Collection<@NonNull HK> var2);

    public Long increment(@NonNull H var1, @NonNull HK var2, long var3);

    public Double increment(@NonNull H var1, @NonNull HK var2, double var3);

    public HK randomKey(@NonNull H var1);

    public Map.Entry<@NonNull HK, HV> randomEntry(@NonNull H var1);

    public List<@NonNull HK> randomKeys(@NonNull H var1, long var2);

    public Map<@NonNull HK, HV> randomEntries(@NonNull H var1, long var2);

    public Set<@NonNull HK> keys(@NonNull H var1);

    public Long lengthOfValue(@NonNull H var1, @NonNull HK var2);

    public Long size(@NonNull H var1);

    public void putAll(@NonNull H var1, @NonNull Map<? extends @NonNull HK, ? extends HV> var2);

    public void put(@NonNull H var1, @NonNull HK var2, HV var3);

    public Boolean putIfAbsent(@NonNull H var1, @NonNull HK var2, HV var3);

    public List<HV> values(@NonNull H var1);

    public Map<@NonNull HK, HV> entries(@NonNull H var1);

    public @NonNull Cursor<Map.Entry<@NonNull HK, HV>> scan(@NonNull H var1, @Nullable ScanOptions var2);

    public ExpireChanges<@NonNull HK> expire(@NonNull H var1, @NonNull Duration var2, @NonNull Collection<@NonNull HK> var3);

    public ExpireChanges<@NonNull HK> expireAt(@NonNull H var1, @NonNull Instant var2, @NonNull Collection<@NonNull HK> var3);

    public ExpireChanges<@NonNull HK> expire(@NonNull H var1, @NonNull Expiration var2, @NonNull ExpirationOptions var3, @NonNull Collection<@NonNull HK> var4);

    public ExpireChanges<@NonNull HK> persist(@NonNull H var1, @NonNull Collection<@NonNull HK> var2);

    default public Expirations<@NonNull HK> getTimeToLive(@NonNull H key, Collection<@NonNull HK> hashKeys) {
        return this.getTimeToLive(key, TimeUnit.SECONDS, hashKeys);
    }

    public Expirations<@NonNull HK> getTimeToLive(@NonNull H var1, @NonNull TimeUnit var2, @NonNull Collection<@NonNull HK> var3);

    default public @NonNull BoundHashFieldExpirationOperations<HK> expiration(@NonNull H key) {
        return new DefaultBoundHashFieldExpirationOperations(this, key, () -> this.keys(key));
    }

    default public @NonNull BoundHashFieldExpirationOperations<HK> expiration(@NonNull H key, HK ... hashFields) {
        return this.expiration(key, (Collection<HK>)Arrays.asList(hashFields));
    }

    default public @NonNull BoundHashFieldExpirationOperations<HK> expiration(@NonNull H key, @NonNull Collection<@NonNull HK> hashFields) {
        return new DefaultBoundHashFieldExpirationOperations(this, key, () -> hashFields);
    }

    public @NonNull RedisOperations<H, ?> getOperations();
}

