/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.convert.SetConverter;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.params.ZParams;
import redis.clients.jedis.params.ZRangeParams;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.util.KeyValue;

@NullUnmarked
class JedisClusterZSetCommands
implements RedisZSetCommands {
    private static final SetConverter<redis.clients.jedis.resps.Tuple, Tuple> TUPLE_SET_CONVERTER = new SetConverter(JedisConverters::toTuple);
    private final JedisClusterConnection connection;

    JedisClusterZSetCommands(@NonNull JedisClusterConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean zAdd(byte @NonNull [] key, double score, byte @NonNull [] value, @NonNull RedisZSetCommands.ZAddArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().zadd(key, score, value, JedisConverters.toZAddParams(args)));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zAdd(byte @NonNull [] key, @NonNull Set<@NonNull Tuple> tuples, @NonNull RedisZSetCommands.ZAddArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(tuples, (String)"Tuples must not be null");
        try {
            return this.connection.getCluster().zadd(key, JedisConverters.toTupleMap(tuples), JedisConverters.toZAddParams(args));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRem(byte @NonNull [] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)values, (String)"Values must not be null");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements");
        try {
            return this.connection.getCluster().zrem(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zIncrBy(byte @NonNull [] key, double increment, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        try {
            return this.connection.getCluster().zincrby(key, increment, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] zRandMember(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().zrandmember(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> zRandMember(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return new ArrayList<byte[]>(this.connection.getCluster().zrandmember(key, count));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Tuple zRandMemberWithScore(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            List tuples = this.connection.getCluster().zrandmemberWithScores(key, 1L);
            return tuples.isEmpty() ? null : JedisConverters.toTuple((redis.clients.jedis.resps.Tuple)tuples.iterator().next());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Tuple> zRandMemberWithScore(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            List tuples = this.connection.getCluster().zrandmemberWithScores(key, count);
            return tuples.stream().map(JedisConverters::toTuple).collect(Collectors.toList());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRank(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        try {
            return this.connection.getCluster().zrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRevRank(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        try {
            return this.connection.getCluster().zrevrank(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte @NonNull []> zRange(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return new LinkedHashSet<byte[]>(this.connection.getCluster().zrange(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<Tuple> zRangeByScoreWithScores(byte @NonNull [] key, @NonNull Range<? extends Number> range, @NonNull Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range cannot be null for ZRANGEBYSCOREWITHSCORES");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit.isUnlimited()) {
                return JedisClusterZSetCommands.toTupleSet(this.connection.getCluster().zrangeByScoreWithScores(key, min, max));
            }
            return JedisClusterZSetCommands.toTupleSet(this.connection.getCluster().zrangeByScoreWithScores(key, min, max, limit.getOffset(), limit.getCount()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte @NonNull [] key, @NonNull Range<? extends Number> range, @NonNull Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range cannot be null for ZREVRANGEBYSCORE");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit.isUnlimited()) {
                return new LinkedHashSet<byte[]>(this.connection.getCluster().zrevrangeByScore(key, max, min));
            }
            return new LinkedHashSet<byte[]>(this.connection.getCluster().zrevrangeByScore(key, max, min, limit.getOffset(), limit.getCount()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<Tuple> zRevRangeByScoreWithScores(byte @NonNull [] key, @NonNull Range<? extends Number> range, @NonNull Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range cannot be null for ZREVRANGEBYSCOREWITHSCORES");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit.isUnlimited()) {
                return JedisClusterZSetCommands.toTupleSet(this.connection.getCluster().zrevrangeByScoreWithScores(key, max, min));
            }
            return JedisClusterZSetCommands.toTupleSet(this.connection.getCluster().zrevrangeByScoreWithScores(key, max, min, limit.getOffset(), limit.getCount()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte @NonNull [] key, @NonNull Range<? extends Number> range) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range cannot be null for ZCOUNT");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            return this.connection.getCluster().zcount(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zLexCount(byte @NonNull [] key, @NonNull Range<byte[]> range) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getUpperBound(), JedisConverters.PLUS_BYTES);
        try {
            return this.connection.getCluster().zlexcount(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Tuple zPopMin(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            redis.clients.jedis.resps.Tuple tuple = this.connection.getCluster().zpopmin(key);
            return tuple != null ? JedisConverters.toTuple(tuple) : null;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<Tuple> zPopMin(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return JedisClusterZSetCommands.toTupleSet(this.connection.getCluster().zpopmin(key, Math.toIntExact(count)));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Tuple bZPopMin(byte @NonNull [] key, long timeout, @NonNull TimeUnit unit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)((Object)unit), (String)"TimeUnit must not be null");
        try {
            return JedisClusterZSetCommands.toTuple(this.connection.getCluster().bzpopmin(JedisConverters.toSeconds(timeout, unit), (byte[][])new byte[][]{key}));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Tuple zPopMax(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            redis.clients.jedis.resps.Tuple tuple = this.connection.getCluster().zpopmax(key);
            return tuple != null ? JedisConverters.toTuple(tuple) : null;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<Tuple> zPopMax(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return JedisClusterZSetCommands.toTupleSet(this.connection.getCluster().zpopmax(key, Math.toIntExact(count)));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Tuple bZPopMax(byte @NonNull [] key, long timeout, @NonNull TimeUnit unit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)((Object)unit), (String)"TimeUnit must not be null");
        try {
            return JedisClusterZSetCommands.toTuple(this.connection.getCluster().bzpopmax(JedisConverters.toSeconds(timeout, unit), (byte[][])new byte[][]{key}));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte @NonNull [] key, @NonNull Range<? extends Number> range) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range cannot be null for ZREMRANGEBYSCORE");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            return this.connection.getCluster().zremrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<@NonNull byte[]> zRangeByScore(byte @NonNull [] key, @NonNull Range<? extends Number> range, @NonNull Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range cannot be null for ZRANGEBYSCORE");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        try {
            if (limit.isUnlimited()) {
                return new LinkedHashSet<byte[]>(this.connection.getCluster().zrangeByScore(key, min, max));
            }
            return new LinkedHashSet<byte[]>(this.connection.getCluster().zrangeByScore(key, min, max, limit.getOffset(), limit.getCount()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte @NonNull []> zRangeByLex(byte @NonNull [] key, @NonNull Range<byte[]> range, @NonNull Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null for ZRANGEBYLEX");
        Assert.notNull((Object)limit, (String)"Limit must not be null");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getUpperBound(), JedisConverters.PLUS_BYTES);
        try {
            if (limit.isUnlimited()) {
                return new LinkedHashSet<byte[]>(this.connection.getCluster().zrangeByLex(key, min, max));
            }
            return new LinkedHashSet<byte[]>(this.connection.getCluster().zrangeByLex(key, min, max, limit.getOffset(), limit.getCount()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByLex(byte @NonNull [] key, @NonNull Range<byte[]> range) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null for ZREMRANGEBYLEX");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getUpperBound(), JedisConverters.PLUS_BYTES);
        try {
            return this.connection.getCluster().zremrangeByLex(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte @NonNull []> zRevRangeByLex(byte @NonNull [] key, @NonNull Range<byte[]> range, @NonNull Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null for ZREVRANGEBYLEX");
        Assert.notNull((Object)limit, (String)"Limit must not be null");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getUpperBound(), JedisConverters.PLUS_BYTES);
        try {
            if (limit.isUnlimited()) {
                return new LinkedHashSet<byte[]>(this.connection.getCluster().zrevrangeByLex(key, max, min));
            }
            return new LinkedHashSet<byte[]>(this.connection.getCluster().zrevrangeByLex(key, max, min, limit.getOffset(), limit.getCount()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRangeStoreByLex(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull Range<byte[]> range, @NonNull Limit limit) {
        return this.zRangeStoreByLex(dstKey, srcKey, range, limit, false);
    }

    @Override
    public Long zRangeStoreRevByLex(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull Range<byte[]> range, @NonNull Limit limit) {
        return this.zRangeStoreByLex(dstKey, srcKey, range, limit, true);
    }

    private Long zRangeStoreByLex(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull Range<byte[]> range, @NonNull Limit limit, boolean rev) {
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null");
        Assert.notNull((Object)srcKey, (String)"Source key must not be null");
        Assert.notNull(range, (String)"Range must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null. Use Limit.unlimited() instead.");
        byte[] min = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getLowerBound(), JedisConverters.MINUS_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRangeByLex((Range.Bound<byte[]>)range.getUpperBound(), JedisConverters.PLUS_BYTES);
        ZRangeParams zRangeParams = new ZRangeParams(Protocol.Keyword.BYLEX, min, max);
        if (limit.isLimited()) {
            zRangeParams = zRangeParams.limit(limit.getOffset(), limit.getCount());
        }
        if (rev) {
            zRangeParams = zRangeParams.rev();
        }
        try {
            return this.connection.getCluster().zrangestore(dstKey, srcKey, zRangeParams);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public @Nullable Long zRangeStoreByScore(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull Range<? extends Number> range, @NonNull Limit limit) {
        return this.zRangeStoreByScore(dstKey, srcKey, range, limit, false);
    }

    @Override
    public @Nullable Long zRangeStoreRevByScore(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull Range<? extends Number> range, @NonNull Limit limit) {
        return this.zRangeStoreByScore(dstKey, srcKey, range, limit, true);
    }

    private Long zRangeStoreByScore(byte @NonNull [] dstKey, byte @NonNull [] srcKey, @NonNull Range<? extends Number> range, @NonNull Limit limit, boolean rev) {
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null");
        Assert.notNull((Object)srcKey, (String)"Source key must not be null");
        Assert.notNull(range, (String)"Range for must not be null");
        Assert.notNull((Object)limit, (String)"Limit must not be null. Use Limit.unlimited() instead.");
        byte[] min = JedisConverters.boundaryToBytesForZRange(range.getLowerBound(), JedisConverters.NEGATIVE_INFINITY_BYTES);
        byte[] max = JedisConverters.boundaryToBytesForZRange(range.getUpperBound(), JedisConverters.POSITIVE_INFINITY_BYTES);
        ZRangeParams zRangeParams = new ZRangeParams(Protocol.Keyword.BYSCORE, min, max);
        if (limit.isLimited()) {
            zRangeParams = zRangeParams.limit(limit.getOffset(), limit.getCount());
        }
        if (rev) {
            zRangeParams = zRangeParams.rev();
        }
        try {
            return this.connection.getCluster().zrangestore(dstKey, srcKey, zRangeParams);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<@NonNull Tuple> zRangeWithScores(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return JedisClusterZSetCommands.toTupleSet(this.connection.getCluster().zrangeWithScores(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte @NonNull []> zRangeByScore(byte @NonNull [] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return new LinkedHashSet<byte[]>(this.connection.getCluster().zrangeByScore(key, min, max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<@NonNull Tuple> zRangeByScoreWithScores(byte @NonNull [] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return JedisClusterZSetCommands.toTupleSet(this.connection.getCluster().zrangeByScoreWithScores(key, min, max));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte @NonNull []> zRangeByScore(byte @NonNull [] key, double min, double max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE");
        }
        try {
            return new LinkedHashSet<byte[]>(this.connection.getCluster().zrangeByScore(key, min, max, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<@NonNull Tuple> zRangeByScoreWithScores(byte @NonNull [] key, double min, double max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE");
        }
        try {
            return JedisClusterZSetCommands.toTupleSet(this.connection.getCluster().zrangeByScoreWithScores(key, min, max, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte @NonNull []> zRevRange(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return new LinkedHashSet<byte[]>(this.connection.getCluster().zrevrange(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<@NonNull Tuple> zRevRangeWithScores(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return JedisClusterZSetCommands.toTupleSet(this.connection.getCluster().zrevrangeWithScores(key, start, end));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte @NonNull []> zRevRangeByScore(byte @NonNull [] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return new LinkedHashSet<byte[]>(this.connection.getCluster().zrevrangeByScore(key, max, min));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<@NonNull Tuple> zRevRangeByScoreWithScores(byte @NonNull [] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return JedisClusterZSetCommands.toTupleSet(this.connection.getCluster().zrevrangeByScoreWithScores(key, max, min));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte @NonNull []> zRevRangeByScore(byte @NonNull [] key, double min, double max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE");
        }
        try {
            return new LinkedHashSet<byte[]>(this.connection.getCluster().zrevrangeByScore(key, max, min, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<@NonNull Tuple> zRevRangeByScoreWithScores(byte @NonNull [] key, double min, double max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE");
        }
        try {
            return JedisClusterZSetCommands.toTupleSet(this.connection.getCluster().zrevrangeByScoreWithScores(key, max, min, Long.valueOf(offset).intValue(), Long.valueOf(count).intValue()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCount(byte @NonNull [] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().zcount(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zCard(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().zcard(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double zScore(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        try {
            return this.connection.getCluster().zscore(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<Double> zMScore(byte @NonNull [] key, byte @NonNull [] @NonNull [] values) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)values, (String)"Values must not be null");
        try {
            return this.connection.getCluster().zmscore(key, values);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRange(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().zremrangeByRank(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long zRemRangeByScore(byte @NonNull [] key, double min, double max) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().zremrangeByScore(key, min, max);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte @NonNull []> zDiff(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sets)) {
            try {
                return JedisConverters.toSet(this.connection.getCluster().zdiff(sets));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZDIFF can only be executed when all keys map to the same slot");
    }

    @Override
    public Set<Tuple> zDiffWithScores(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sets)) {
            try {
                return JedisConverters.toSet(JedisConverters.toTupleList(this.connection.getCluster().zdiffWithScores(sets)));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZDIFF can only be executed when all keys map to the same slot");
    }

    @Override
    public Long zDiffStore(byte @NonNull [] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)sets, (String)"Source sets must not be null");
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.connection.getCluster().zdiffStore(destKey, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZDIFFSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Set<byte @NonNull []> zInter(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sets)) {
            try {
                return JedisConverters.toSet(this.connection.getCluster().zinter(new ZParams(), sets));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZINTER can only be executed when all keys map to the same slot");
    }

    @Override
    public Set<@NonNull Tuple> zInterWithScores(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sets)) {
            try {
                return JedisConverters.toSet(JedisConverters.toTupleList(this.connection.getCluster().zinterWithScores(new ZParams(), sets)));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZINTER can only be executed when all keys map to the same slot");
    }

    @Override
    public Set<@NonNull Tuple> zInterWithScores(@NonNull Aggregate aggregate, @NonNull Weights weights, byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements");
        Assert.isTrue((weights.size() == sets.length ? 1 : 0) != 0, () -> "The number of weights %d must match the number of source sets %d".formatted(weights.size(), sets.length));
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sets)) {
            try {
                return JedisConverters.toSet(JedisConverters.toTupleList(this.connection.getCluster().zinterWithScores(JedisClusterZSetCommands.toZParams(aggregate, weights), sets)));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZINTER can only be executed when all keys map to the same slot");
    }

    @Override
    public Long zInterStore(byte @NonNull [] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)sets, (String)"Source sets must not be null");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements");
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.connection.getCluster().zinterstore(destKey, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZINTERSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Long zInterStore(byte @NonNull [] destKey, @NonNull Aggregate aggregate, @NonNull Weights weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)sets, (String)"Source sets must not be null");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements");
        Assert.isTrue((weights.size() == sets.length ? 1 : 0) != 0, (String)"The number of weights %d must match the number of source sets %d".formatted(weights.size(), sets.length));
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.connection.getCluster().zinterstore(destKey, JedisClusterZSetCommands.toZParams(aggregate, weights), sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new IllegalArgumentException("ZINTERSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Set<byte @NonNull []> zUnion(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sets)) {
            try {
                return JedisConverters.toSet(this.connection.getCluster().zunion(new ZParams(), sets));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZUNION can only be executed when all keys map to the same slot");
    }

    @Override
    public Set<@NonNull Tuple> zUnionWithScores(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sets)) {
            try {
                return JedisConverters.toSet(JedisConverters.toTupleList(this.connection.getCluster().zunionWithScores(new ZParams(), sets)));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZUNION can only be executed when all keys map to the same slot");
    }

    @Override
    public Set<@NonNull Tuple> zUnionWithScores(@NonNull Aggregate aggregate, @NonNull Weights weights, byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements");
        Assert.isTrue((weights.size() == sets.length ? 1 : 0) != 0, () -> "The number of weights %d must match the number of source sets %d".formatted(weights.size(), sets.length));
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sets)) {
            try {
                return JedisConverters.toSet(JedisConverters.toTupleList(this.connection.getCluster().zunionWithScores(JedisClusterZSetCommands.toZParams(aggregate, weights), sets)));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZUNION can only be executed when all keys map to the same slot");
    }

    @Override
    public Long zUnionStore(byte @NonNull [] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)sets, (String)"Source sets must not be null");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements");
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            try {
                return this.connection.getCluster().zunionstore(destKey, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZUNIONSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Long zUnionStore(byte @NonNull [] destKey, @NonNull Aggregate aggregate, @NonNull Weights weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null");
        Assert.notNull((Object)sets, (String)"Source sets must not be null");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements");
        Assert.isTrue((weights.size() == sets.length ? 1 : 0) != 0, (String)"The number of weights %d must match the number of source sets %d".formatted(weights.size(), sets.length));
        byte[][] allKeys = ByteUtils.mergeArrays(destKey, sets);
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(allKeys)) {
            ZParams zparams = JedisClusterZSetCommands.toZParams(aggregate, weights);
            try {
                return this.connection.getCluster().zunionstore(destKey, zparams, sets);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        throw new InvalidDataAccessApiUsageException("ZUNIONSTORE can only be executed when all keys map to the same slot");
    }

    @Override
    public Cursor<@NonNull Tuple> zScan(final byte @NonNull [] key, @NonNull ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return new ScanCursor<Tuple>(this, options){
            final /* synthetic */ JedisClusterZSetCommands this$0;
            {
                this.this$0 = this$0;
                super(options);
            }

            @Override
            protected ScanIteration<Tuple> doScan(Cursor.CursorId cursorId, ScanOptions options) {
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = this.this$0.connection.getCluster().zscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<Tuple>(Cursor.CursorId.of(result.getCursor()), JedisConverters.tuplesToTuples().convert(result.getResult()));
            }
        }.open();
    }

    @Override
    public Set<byte @NonNull []> zRangeByScore(byte @NonNull [] key, @NonNull String min, @NonNull String max) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return new LinkedHashSet<byte[]>(this.connection.getCluster().zrangeByScore(key, JedisConverters.toBytes(min), JedisConverters.toBytes(max)));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Set<byte @NonNull []> zRangeByScore(byte @NonNull [] key, @NonNull String min, @NonNull String max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (offset > Integer.MAX_VALUE || count > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Count/Offset cannot exceed Integer.MAX_VALUE");
        }
        try {
            return new LinkedHashSet<byte[]>(this.connection.getCluster().zrangeByScore(key, JedisConverters.toBytes(min), JedisConverters.toBytes(max), Long.valueOf(offset).intValue(), Long.valueOf(count).intValue()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }

    private static Set<Tuple> toTupleSet(List<redis.clients.jedis.resps.Tuple> source) {
        return TUPLE_SET_CONVERTER.convert(source);
    }

    private static ZParams toZParams(Aggregate aggregate, Weights weights) {
        return new ZParams().weights(weights.toArray()).aggregate(ZParams.Aggregate.valueOf((String)aggregate.name()));
    }

    @Contract(value="null -> null")
    private static @Nullable Tuple toTuple(@Nullable KeyValue<?, redis.clients.jedis.resps.Tuple> keyValue) {
        if (keyValue != null) {
            redis.clients.jedis.resps.Tuple tuple = (redis.clients.jedis.resps.Tuple)keyValue.getValue();
            return tuple != null ? JedisConverters.toTuple(tuple) : null;
        }
        return null;
    }
}

