/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterSlotHashUtil;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.args.ExpiryOption;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

@NullUnmarked
class JedisClusterKeyCommands
implements RedisKeyCommands {
    private final JedisClusterConnection connection;

    JedisClusterKeyCommands(JedisClusterConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean copy(byte @NonNull [] sourceKey, byte @NonNull [] targetKey, boolean replace) {
        Assert.notNull((Object)sourceKey, (String)"source key must not be null");
        Assert.notNull((Object)targetKey, (String)"target key must not be null");
        return this.connection.getCluster().copy(sourceKey, targetKey, replace);
    }

    @Override
    public Long del(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.connection.getCluster().del(keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        return this.connection.getClusterCommandExecutor().executeMultiKeyCommand(Jedis::del, Arrays.asList(keys)).resultsAsList().size();
    }

    @Override
    public Long unlink(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        return this.connection.execute("UNLINK", Arrays.asList(keys), Collections.emptyList()).stream().mapToLong(val -> val).sum();
    }

    @Override
    public DataType type(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return JedisConverters.toDataType(this.connection.getCluster().type(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long touch(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        return this.connection.execute("TOUCH", Arrays.asList(keys), Collections.emptyList()).stream().mapToLong(val -> val).sum();
    }

    @Override
    public Set<byte @NonNull []> keys(byte @NonNull [] pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null");
        List keysPerNode = this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(client -> client.keys(pattern)).resultsAsList();
        HashSet<byte[]> keys = new HashSet<byte[]>();
        for (Set keySet : keysPerNode) {
            keys.addAll(keySet);
        }
        return keys;
    }

    public Set<byte @NonNull []> keys(@NonNull RedisClusterNode node, byte @NonNull [] pattern) {
        Assert.notNull((Object)node, (String)"RedisClusterNode must not be null");
        Assert.notNull((Object)pattern, (String)"Pattern must not be null");
        return (Set)this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(client -> client.keys(pattern), node).getValue();
    }

    @Override
    public Cursor<byte @NonNull []> scan(@Nullable ScanOptions options) {
        throw new InvalidDataAccessApiUsageException("Scan is not supported across multiple nodes within a cluster");
    }

    Cursor<byte @NonNull []> scan(@NonNull RedisClusterNode node, @NonNull ScanOptions options) {
        Assert.notNull((Object)node, (String)"RedisClusterNode must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        return (Cursor)this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(client -> new ScanCursor<byte[]>(this, 0L, options){
            final /* synthetic */ JedisClusterKeyCommands this$0;
            {
                this.this$0 = this$0;
                super(cursorId, options);
            }

            @Override
            protected ScanIteration<byte @NonNull []> doScan(@NonNull Cursor.CursorId cursorId, @NonNull ScanOptions options) {
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = client.scan(cursorId.getCursorId(), params);
                return new ScanIteration<byte[]>(Cursor.CursorId.of(result.getCursor()), JedisConverters.stringListToByteList().convert(result.getResult()));
            }
        }.open(), node).getValue();
    }

    @Override
    public byte[] randomKey() {
        ArrayList<RedisClusterNode> nodes = new ArrayList<RedisClusterNode>(this.connection.getTopologyProvider().getTopology().getActiveMasterNodes());
        HashSet<RedisClusterNode> inspectedNodes = new HashSet<RedisClusterNode>(nodes.size());
        do {
            RedisClusterNode node = (RedisClusterNode)nodes.get(ThreadLocalRandom.current().nextInt(nodes.size()));
            while (inspectedNodes.contains(node)) {
                node = (RedisClusterNode)nodes.get(ThreadLocalRandom.current().nextInt(nodes.size()));
            }
            inspectedNodes.add(node);
            byte[] key = this.randomKey(node);
            if (key == null || key.length <= 0) continue;
            return key;
        } while (nodes.size() != inspectedNodes.size());
        return null;
    }

    public byte[] randomKey(@NonNull RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"RedisClusterNode must not be null");
        return (byte[])this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(Jedis::randomBinaryKey, node).getValue();
    }

    @Override
    public void rename(byte @NonNull [] oldKey, byte @NonNull [] newKey) {
        Assert.notNull((Object)oldKey, (String)"Old key must not be null");
        Assert.notNull((Object)newKey, (String)"New key must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(oldKey, newKey)) {
            try {
                this.connection.getCluster().rename(oldKey, newKey);
                return;
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        byte[] value = this.dump(oldKey);
        if (value != null && value.length > 0) {
            this.restore(newKey, 0L, value, true);
            this.del(new byte[][]{oldKey});
        }
    }

    @Override
    public Boolean renameNX(byte @NonNull [] sourceKey, byte @NonNull [] targetKey) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null");
        Assert.notNull((Object)targetKey, (String)"Target key must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(sourceKey, targetKey)) {
            try {
                return JedisConverters.toBoolean(this.connection.getCluster().renamenx(sourceKey, targetKey));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        byte[] value = this.dump(sourceKey);
        if (value != null && value.length > 0 && !this.exists(targetKey).booleanValue()) {
            this.restore(targetKey, 0L, value);
            this.del(new byte[][]{sourceKey});
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean expire(byte @NonNull [] key, long seconds, @NonNull ExpirationOptions.Condition condition) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            if (condition == ExpirationOptions.Condition.ALWAYS) {
                return JedisConverters.toBoolean(this.connection.getCluster().expire(key, seconds));
            }
            return JedisConverters.toBoolean(this.connection.getCluster().expire(key, seconds, ExpiryOption.valueOf((String)condition.name())));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean pExpire(byte @NonNull [] key, long millis, @NonNull ExpirationOptions.Condition condition) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            if (condition == ExpirationOptions.Condition.ALWAYS) {
                return JedisConverters.toBoolean(this.connection.getCluster().pexpire(key, millis));
            }
            return JedisConverters.toBoolean(this.connection.getCluster().pexpire(key, millis, ExpiryOption.valueOf((String)condition.name())));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean expireAt(byte @NonNull [] key, long unixTime, @NonNull ExpirationOptions.Condition condition) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            if (condition == ExpirationOptions.Condition.ALWAYS) {
                return JedisConverters.toBoolean(this.connection.getCluster().expireAt(key, unixTime));
            }
            return JedisConverters.toBoolean(this.connection.getCluster().expireAt(key, unixTime, ExpiryOption.valueOf((String)condition.name())));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean pExpireAt(byte @NonNull [] key, long unixTimeInMillis, @NonNull ExpirationOptions.Condition condition) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            if (condition == ExpirationOptions.Condition.ALWAYS) {
                return JedisConverters.toBoolean(this.connection.getCluster().pexpireAt(key, unixTimeInMillis));
            }
            return JedisConverters.toBoolean(this.connection.getCluster().pexpireAt(key, unixTimeInMillis, ExpiryOption.valueOf((String)condition.name())));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean persist(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return JedisConverters.toBoolean(this.connection.getCluster().persist(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean move(byte @NonNull [] key, int dbIndex) {
        throw new InvalidDataAccessApiUsageException("Cluster mode does not allow moving keys");
    }

    @Override
    public Long ttl(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().ttl(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long ttl(byte @NonNull [] key, @NonNull TimeUnit timeUnit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return Converters.secondsToTimeUnit(this.connection.getCluster().ttl(key), timeUnit);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().pttl(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long pTtl(byte @NonNull [] key, @NonNull TimeUnit timeUnit) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return Converters.millisecondsToTimeUnit(this.connection.getCluster().pttl(key), timeUnit);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] dump(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().dump(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void restore(byte @NonNull [] key, long ttlInMillis, byte @NonNull [] serializedValue, boolean replace) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)serializedValue, (String)"Serialized value must not be null");
        RestoreParams restoreParams = RestoreParams.restoreParams();
        if (replace) {
            restoreParams = restoreParams.replace();
        }
        try {
            this.connection.getCluster().restore(key, ttlInMillis, serializedValue, restoreParams);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> sort(byte @NonNull [] key, @Nullable SortParameters params) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().sort(key, JedisConverters.toSortingParams(params));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long sort(byte @NonNull [] key, @Nullable SortParameters params, byte @NonNull [] storeKey) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(key, storeKey)) {
            try {
                return this.connection.getCluster().sort(key, JedisConverters.toSortingParams(params), storeKey);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        List<byte[]> sorted = this.sort(key, params);
        byte[][] arr = new byte[sorted.size()][];
        this.connection.keyCommands().unlink(new byte[][]{storeKey});
        this.connection.listCommands().lPush(storeKey, (byte[][])sorted.toArray((T[])arr));
        return sorted.size();
    }

    @Override
    public Long exists(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        if (ClusterSlotHashUtil.isSameSlotForAllKeys(keys)) {
            try {
                return this.connection.getCluster().exists(keys);
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        return this.connection.getClusterCommandExecutor().executeMultiKeyCommand(Jedis::exists, Arrays.asList(keys)).resultsAsList().stream().mapToLong(val -> ObjectUtils.nullSafeEquals((Object)val, (Object)Boolean.TRUE) ? 1L : 0L).sum();
    }

    @Override
    public ValueEncoding encodingOf(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return JedisConverters.toEncoding(this.connection.getCluster().objectEncoding(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Duration idletime(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return Converters.secondsToDuration(this.connection.getCluster().objectIdletime(key));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long refcount(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        try {
            return this.connection.getCluster().objectRefcount(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private DataAccessException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }
}

