/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.ObjectUtils;

@NullUnmarked
public interface RedisHashCommands {
    public Boolean hSet(byte @NonNull [] var1, byte @NonNull [] var2, byte @NonNull [] var3);

    public Boolean hSetNX(byte @NonNull [] var1, byte @NonNull [] var2, byte @NonNull [] var3);

    public byte[] hGet(byte @NonNull [] var1, byte @NonNull [] var2);

    public List<byte[]> hMGet(byte @NonNull [] var1, byte[] ... var2);

    public void hMSet(byte @NonNull [] var1, Map<byte[], byte[]> var2);

    public Long hIncrBy(byte @NonNull [] var1, byte @NonNull [] var2, long var3);

    public Double hIncrBy(byte @NonNull [] var1, byte @NonNull [] var2, double var3);

    public Boolean hExists(byte @NonNull [] var1, byte @NonNull [] var2);

    public Long hDel(byte @NonNull [] var1, byte[] ... var2);

    public Long hLen(byte @NonNull [] var1);

    public Set<byte @NonNull []> hKeys(byte @NonNull [] var1);

    public List<byte @NonNull []> hVals(byte @NonNull [] var1);

    public Map<byte @NonNull [], byte @NonNull []> hGetAll(byte @NonNull [] var1);

    public byte[] hRandField(byte @NonNull [] var1);

    public Map.Entry<byte @NonNull [], byte @NonNull []> hRandFieldWithValues(byte @NonNull [] var1);

    public List<byte @NonNull []> hRandField(byte @NonNull [] var1, long var2);

    public List<@NonNull Map.Entry<byte @NonNull [], byte @NonNull []>> hRandFieldWithValues(byte @NonNull [] var1, long var2);

    public Cursor<@NonNull Map.Entry<byte @NonNull [], byte @NonNull []>> hScan(byte @NonNull [] var1, ScanOptions var2);

    public Long hStrLen(byte @NonNull [] var1, byte @NonNull [] var2);

    default public List<@NonNull Long> applyHashFieldExpiration(byte @NonNull [] key, @NonNull Expiration expiration, byte[] ... fields) {
        return this.applyHashFieldExpiration(key, expiration, ExpirationOptions.none(), fields);
    }

    default public List<@NonNull Long> applyHashFieldExpiration(byte @NonNull [] key, @NonNull Expiration expiration, @NonNull ExpirationOptions options, byte[] ... fields) {
        if (expiration.isPersistent()) {
            return this.hPersist(key, fields);
        }
        if (ObjectUtils.nullSafeEquals((Object)ExpirationOptions.none(), (Object)options)) {
            if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)expiration.getTimeUnit()))) {
                if (expiration.isUnixTimestamp()) {
                    return this.hpExpireAt(key, expiration.getExpirationTimeInMilliseconds(), fields);
                }
                return this.hpExpire(key, expiration.getExpirationTimeInMilliseconds(), fields);
            }
            if (expiration.isUnixTimestamp()) {
                return this.hExpireAt(key, expiration.getExpirationTimeInSeconds(), fields);
            }
            return this.hExpire(key, expiration.getExpirationTimeInSeconds(), fields);
        }
        if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)expiration.getTimeUnit()))) {
            if (expiration.isUnixTimestamp()) {
                return this.hpExpireAt(key, expiration.getExpirationTimeInMilliseconds(), options.getCondition(), fields);
            }
            return this.hpExpire(key, expiration.getExpirationTimeInMilliseconds(), options.getCondition(), fields);
        }
        if (expiration.isUnixTimestamp()) {
            return this.hExpireAt(key, expiration.getExpirationTimeInSeconds(), options.getCondition(), fields);
        }
        return this.hExpire(key, expiration.getExpirationTimeInSeconds(), options.getCondition(), fields);
    }

    default public List<@NonNull Long> hExpire(byte @NonNull [] key, long seconds, byte[] ... fields) {
        return this.hExpire(key, seconds, ExpirationOptions.Condition.ALWAYS, fields);
    }

    default public List<@NonNull Long> hExpire(byte @NonNull [] key, @NonNull Duration ttl, byte[] ... fields) {
        return this.hExpire(key, ttl.toSeconds(), fields);
    }

    public List<@NonNull Long> hExpire(byte @NonNull [] var1, long var2, @NonNull ExpirationOptions.Condition var4, byte[] ... var5);

    default public List<@NonNull Long> hpExpire(byte @NonNull [] key, long millis, byte[] ... fields) {
        return this.hpExpire(key, millis, ExpirationOptions.Condition.ALWAYS, fields);
    }

    default public List<@NonNull Long> hpExpire(byte @NonNull [] key, @NonNull Duration ttl, byte[] ... fields) {
        return this.hpExpire(key, ttl.toMillis(), fields);
    }

    public List<@NonNull Long> hpExpire(byte @NonNull [] var1, long var2, @NonNull ExpirationOptions.Condition var4, byte[] ... var5);

    default public List<Long> hExpireAt(byte @NonNull [] key, long unixTime, byte[] ... fields) {
        return this.hExpireAt(key, unixTime, ExpirationOptions.Condition.ALWAYS, fields);
    }

    public List<@NonNull Long> hExpireAt(byte @NonNull [] var1, long var2, @NonNull ExpirationOptions.Condition var4, byte[] ... var5);

    default public List<@NonNull Long> hpExpireAt(byte @NonNull [] key, long unixTimeInMillis, byte[] ... fields) {
        return this.hpExpireAt(key, unixTimeInMillis, ExpirationOptions.Condition.ALWAYS, fields);
    }

    public List<@NonNull Long> hpExpireAt(byte @NonNull [] var1, long var2, @NonNull ExpirationOptions.Condition var4, byte[] ... var5);

    public List<@NonNull Long> hPersist(byte @NonNull [] var1, byte[] ... var2);

    public List<@NonNull Long> hTtl(byte @NonNull [] var1, byte[] ... var2);

    public List<@NonNull Long> hTtl(byte @NonNull [] var1, @NonNull TimeUnit var2, byte[] ... var3);

    public List<@NonNull Long> hpTtl(byte @NonNull [] var1, byte[] ... var2);
}

