/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ReadFrom;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceFutureUtils;
import org.springframework.data.redis.connection.lettuce.RedisClientProvider;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class ClusterConnectionProvider
implements LettuceConnectionProvider,
RedisClientProvider {
    private volatile boolean initialized;
    private final Lock lock = new ReentrantLock();
    @Nullable
    private final ReadFrom readFrom;
    private final RedisClusterClient client;
    private final RedisCodec<?, ?> codec;

    ClusterConnectionProvider(RedisClusterClient client, RedisCodec<?, ?> codec) {
        this(client, codec, null);
    }

    ClusterConnectionProvider(RedisClusterClient client, RedisCodec<?, ?> codec, @Nullable ReadFrom readFrom) {
        Assert.notNull((Object)client, (String)"Client must not be null");
        Assert.notNull(codec, (String)"Codec must not be null");
        this.client = client;
        this.codec = codec;
        this.readFrom = readFrom;
    }

    private Optional<ReadFrom> getReadFrom() {
        return Optional.ofNullable(this.readFrom);
    }

    public <T extends StatefulConnection<?, ?>> CompletableFuture<T> getConnectionAsync(Class<T> connectionType) {
        block12: {
            block11: {
                if (!this.initialized) {
                    this.lock.lock();
                    try {
                        if (!this.initialized) {
                            this.client.getPartitions();
                            this.initialized = true;
                        }
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                if (connectionType.equals(StatefulRedisPubSubConnection.class)) break block11;
                if (!connectionType.equals(StatefulRedisClusterPubSubConnection.class)) break block12;
            }
            return this.client.connectPubSubAsync(this.codec).thenApply(connectionType::cast);
        }
        if (StatefulRedisClusterConnection.class.isAssignableFrom(connectionType) || connectionType.equals(StatefulConnection.class)) {
            return this.client.connectAsync(this.codec).thenApply(connection -> {
                this.getReadFrom().ifPresent(arg_0 -> ((StatefulRedisClusterConnection)connection).setReadFrom(arg_0));
                return (StatefulConnection)connectionType.cast(connection);
            });
        }
        return LettuceFutureUtils.failed((Throwable)new InvalidDataAccessApiUsageException("Connection type %s not supported".formatted(connectionType)));
    }

    public RedisClusterClient getRedisClient() {
        return this.client;
    }
}

