/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.util.AbstractSubscription;
import org.springframework.lang.Nullable;
import redis.clients.jedis.BinaryJedisPubSub;

class JedisSubscription
extends AbstractSubscription {
    private final BinaryJedisPubSub jedisPubSub;

    JedisSubscription(MessageListener listener, BinaryJedisPubSub jedisPubSub, @Nullable byte[][] channels, @Nullable byte[][] patterns) {
        super(listener, channels, patterns);
        this.jedisPubSub = jedisPubSub;
    }

    @Override
    protected void doClose() {
        if (!this.getChannels().isEmpty()) {
            this.jedisPubSub.unsubscribe();
        }
        if (!this.getPatterns().isEmpty()) {
            this.jedisPubSub.punsubscribe();
        }
    }

    @Override
    protected void doPsubscribe(byte[] ... patterns) {
        this.jedisPubSub.psubscribe((Object[])patterns);
    }

    @Override
    protected void doPUnsubscribe(boolean all, byte[] ... patterns) {
        if (all) {
            this.jedisPubSub.punsubscribe();
        } else {
            this.jedisPubSub.punsubscribe((Object[])patterns);
        }
    }

    @Override
    protected void doSubscribe(byte[] ... channels) {
        this.jedisPubSub.subscribe((Object[])channels);
    }

    @Override
    protected void doUnsubscribe(boolean all, byte[] ... channels) {
        if (all) {
            this.jedisPubSub.unsubscribe();
        } else {
            this.jedisPubSub.unsubscribe((Object[])channels);
        }
    }
}

