/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.CollationUtils;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.util.ClassUtils;

class QueryUtils {
    protected static final Log LOGGER = LogFactory.getLog(QueryUtils.class);

    QueryUtils() {
    }

    static Query decorateSort(Query query, Document defaultSort) {
        BasicQuery bq;
        if (defaultSort.isEmpty()) {
            return query;
        }
        BasicQuery defaultSortQuery = query instanceof BasicQuery ? (bq = (BasicQuery)query) : new BasicQuery(query);
        Document combinedSort = new Document((Map)defaultSort);
        combinedSort.putAll((Map)defaultSortQuery.getSortObject());
        defaultSortQuery.setSortObject(combinedSort);
        return defaultSortQuery;
    }

    static Query applyCollation(Query query, @Nullable String collationExpression, ConvertingParameterAccessor accessor, ValueExpressionEvaluator expressionEvaluator) {
        Collation collation = CollationUtils.computeCollation(collationExpression, accessor, expressionEvaluator);
        return collation == null ? query : query.collation(collation);
    }

    static int indexOfAssignableParameter(Class<?> type, Class<?>[] parameters) {
        return QueryUtils.indexOfAssignableParameter(type, Arrays.asList(parameters));
    }

    static int indexOfAssignableParameter(Class<?> type, List<Class<?>> parameters) {
        if (parameters.isEmpty()) {
            return -1;
        }
        int i = 0;
        for (Class<?> parameterType : parameters) {
            if (ClassUtils.isAssignable(type, parameterType)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

