/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.support.IndexEnsuringQueryCreationListener;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactory;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFragmentsContributor;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

public class MongoRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private @Nullable MongoOperations operations;
    private MongoRepositoryFragmentsContributor repositoryFragmentsContributor = MongoRepositoryFragmentsContributor.DEFAULT;
    private boolean createIndexesForQueryMethods = false;
    private boolean mappingContextConfigured = false;

    public MongoRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setMongoOperations(MongoOperations operations) {
        this.operations = operations;
    }

    public MongoRepositoryFragmentsContributor getRepositoryFragmentsContributor() {
        return this.repositoryFragmentsContributor;
    }

    public void setRepositoryFragmentsContributor(MongoRepositoryFragmentsContributor repositoryFragmentsContributor) {
        this.repositoryFragmentsContributor = repositoryFragmentsContributor;
    }

    public void setCreateIndexesForQueryMethods(boolean createIndexesForQueryMethods) {
        this.createIndexesForQueryMethods = createIndexesForQueryMethods;
    }

    public void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        this.mappingContextConfigured = true;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        MongoRepositoryFactory factory = this.getFactoryInstance(this.operations);
        factory.setFragmentsContributor(this.repositoryFragmentsContributor);
        if (this.createIndexesForQueryMethods) {
            factory.addQueryCreationListener(new IndexEnsuringQueryCreationListener((collectionName, javaType) -> this.operations.indexOps(javaType)));
        }
        return factory;
    }

    protected MongoRepositoryFactory getFactoryInstance(MongoOperations operations) {
        return new MongoRepositoryFactory(operations);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.state((this.operations != null ? 1 : 0) != 0, (String)"MongoTemplate must not be null");
        if (!this.mappingContextConfigured) {
            this.setMappingContext(this.operations.getConverter().getMappingContext());
        }
    }
}

