/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.aggregation.AggregationUpdate;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.data.mongodb.repository.Update;
import org.springframework.data.mongodb.repository.VectorSearch;
import org.springframework.data.mongodb.repository.aot.AggregationInteraction;
import org.springframework.data.mongodb.repository.aot.AggregationUpdateInteraction;
import org.springframework.data.mongodb.repository.aot.AotQueryCreator;
import org.springframework.data.mongodb.repository.aot.AotStringQuery;
import org.springframework.data.mongodb.repository.aot.MongoAotRepositoryFragmentSupport;
import org.springframework.data.mongodb.repository.aot.MongoCodeBlocks;
import org.springframework.data.mongodb.repository.aot.MongoInteraction;
import org.springframework.data.mongodb.repository.aot.NearQueryInteraction;
import org.springframework.data.mongodb.repository.aot.QueryBlocks;
import org.springframework.data.mongodb.repository.aot.QueryInteraction;
import org.springframework.data.mongodb.repository.aot.SearchInteraction;
import org.springframework.data.mongodb.repository.aot.StringUpdate;
import org.springframework.data.mongodb.repository.aot.UpdateInteraction;
import org.springframework.data.mongodb.repository.aot.VectorSearchBlocks;
import org.springframework.data.mongodb.repository.config.MongoRepositoryConfigurationExtension;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.aot.generate.AotRepositoryClassBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.MethodContributor;
import org.springframework.data.repository.aot.generate.QueryMetadata;
import org.springframework.data.repository.aot.generate.RepositoryContributor;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.config.PropertiesBasedNamedQueriesFactoryBean;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.PropertiesBasedNamedQueries;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.TypeName;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MongoRepositoryContributor
extends RepositoryContributor {
    private static final Log logger = LogFactory.getLog(MongoRepositoryContributor.class);
    private final AotQueryCreator queryCreator;
    private final SimpleTypeHolder simpleTypeHolder;
    private final MongoMappingContext mappingContext;
    private final NamedQueries namedQueries;

    public MongoRepositoryContributor(AotRepositoryContext repositoryContext) {
        super(repositoryContext);
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = repositoryContext.getBeanFactory() != null ? repositoryContext.getClassLoader() : null;
        if (classLoader == null) {
            classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        this.namedQueries = this.getNamedQueries(repositoryContext.getConfigurationSource(), classLoader);
        MongoCustomConversions mongoCustomConversions = MongoCustomConversions.create(MongoCustomConversions.MongoConverterConfigurationAdapter::useNativeDriverJavaTimeCodecs);
        this.simpleTypeHolder = mongoCustomConversions.getSimpleTypeHolder();
        this.mappingContext = new MongoMappingContext();
        this.mappingContext.setSimpleTypeHolder(this.simpleTypeHolder);
        this.mappingContext.setAutoIndexCreation(false);
        this.mappingContext.afterPropertiesSet();
        this.queryCreator = new AotQueryCreator((MappingContext<?, MongoPersistentProperty>)this.mappingContext);
    }

    private NamedQueries getNamedQueries(@Nullable RepositoryConfigurationSource configSource, ClassLoader classLoader) {
        String location;
        String string = location = configSource != null ? (String)configSource.getNamedQueryLocation().orElse(null) : null;
        if (location == null) {
            location = new MongoRepositoryConfigurationExtension().getDefaultNamedQueryLocation();
        }
        if (StringUtils.hasText((String)location)) {
            try {
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
                PropertiesBasedNamedQueriesFactoryBean factoryBean = new PropertiesBasedNamedQueriesFactoryBean();
                factoryBean.setLocations(resolver.getResources(location));
                factoryBean.afterPropertiesSet();
                return factoryBean.getObject();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new PropertiesBasedNamedQueries(new Properties());
    }

    protected void customizeClass(AotRepositoryClassBuilder classBuilder) {
        classBuilder.customize(builder -> builder.superclass(TypeName.get(MongoAotRepositoryFragmentSupport.class)));
    }

    protected void customizeConstructor(AotRepositoryConstructorBuilder constructorBuilder) {
        constructorBuilder.addParameter("operations", MongoOperations.class);
        constructorBuilder.addParameter("context", RepositoryFactoryBeanSupport.FragmentCreationContext.class, false);
        constructorBuilder.customize(builder -> builder.addStatement("super(operations, context)", new Object[0]));
    }

    protected @Nullable MethodContributor<? extends QueryMethod> contributeQueryMethod(Method method) {
        MongoQueryMethod queryMethod = new MongoQueryMethod(method, (RepositoryMetadata)this.getRepositoryInformation(), this.getProjectionFactory(), (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)this.mappingContext);
        MethodContributor.RepositoryMethodContribution contribution = null;
        MongoInteraction queryMetadata = null;
        if (queryMethod.hasAnnotatedAggregation()) {
            AggregationInteraction aggregation;
            queryMetadata = aggregation = new AggregationInteraction(queryMethod.getAnnotatedAggregation());
            contribution = MongoRepositoryContributor.aggregationMethodContributor(queryMethod, this.simpleTypeHolder, aggregation);
        } else {
            QueryInteraction query = this.createStringQuery(this.getRepositoryInformation(), queryMethod, (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Query.class), method);
            if (queryMethod.hasAnnotatedVectorSearch()) {
                VectorSearch vectorSearch = queryMethod.getRequiredVectorSearchAnnotation();
                SearchInteraction interaction = new SearchInteraction(this.getRepositoryInformation().getDomainType(), vectorSearch, query.getQuery(), queryMethod.getParameters(), this.mappingContext);
                queryMetadata = interaction;
                contribution = MongoRepositoryContributor.searchMethodContributor(queryMethod, interaction);
            } else if (queryMethod.isGeoNearQuery() || queryMethod.getParameters().getMaxDistanceIndex() != -1 && queryMethod.getReturnType().isCollectionLike()) {
                NearQueryInteraction near = new NearQueryInteraction(query, queryMethod.getParameters());
                queryMetadata = near;
                contribution = MongoRepositoryContributor.nearQueryMethodContributor(queryMethod, near);
            } else if (query.isDelete()) {
                queryMetadata = query;
                contribution = MongoRepositoryContributor.deleteMethodContributor(queryMethod, query);
            } else if (queryMethod.isModifyingQuery()) {
                int updateIndex = queryMethod.getParameters().getUpdateIndex();
                if (updateIndex != -1) {
                    UpdateInteraction update = new UpdateInteraction(query, null, updateIndex);
                    queryMetadata = update;
                    contribution = MongoRepositoryContributor.updateMethodContributor(queryMethod, update);
                } else {
                    MongoInteraction update;
                    Update updateSource = queryMethod.getUpdateSource();
                    if (StringUtils.hasText((String)updateSource.value())) {
                        update = new UpdateInteraction(query, new StringUpdate(updateSource.value()), null);
                        queryMetadata = update;
                        contribution = MongoRepositoryContributor.updateMethodContributor(queryMethod, update);
                    }
                    if (!ObjectUtils.isEmpty((Object[])updateSource.pipeline())) {
                        update = new AggregationUpdateInteraction(query, updateSource.pipeline());
                        queryMetadata = update;
                        contribution = MongoRepositoryContributor.aggregationUpdateMethodContributor(queryMethod, this.simpleTypeHolder, (AggregationUpdateInteraction)update);
                    }
                }
            } else {
                queryMetadata = query;
                contribution = MongoRepositoryContributor.queryMethodContributor(queryMethod, query);
            }
        }
        if (queryMetadata == null) {
            return null;
        }
        if (MongoRepositoryContributor.backoff(queryMethod) || contribution == null) {
            return MethodContributor.forQueryMethod((QueryMethod)queryMethod).metadataOnly((QueryMetadata)queryMetadata);
        }
        return MethodContributor.forQueryMethod((QueryMethod)queryMethod).withMetadata((QueryMetadata)queryMetadata).contribute(contribution);
    }

    private QueryInteraction createStringQuery(RepositoryInformation repositoryInformation, MongoQueryMethod queryMethod, @Nullable Query queryAnnotation, Method source) {
        QueryInteraction query;
        if (queryMethod.hasAnnotatedQuery() && queryAnnotation != null) {
            query = new QueryInteraction(new AotStringQuery(queryMethod.getAnnotatedQuery()), queryAnnotation.count(), queryAnnotation.delete(), queryAnnotation.exists());
        } else if (this.namedQueries.hasQuery(queryMethod.getNamedQueryName())) {
            query = new QueryInteraction(new AotStringQuery(this.namedQueries.getQuery(queryMethod.getNamedQueryName())), queryAnnotation != null && queryAnnotation.count(), queryAnnotation != null && queryAnnotation.delete(), queryAnnotation != null && queryAnnotation.exists());
        } else {
            PartTree partTree = new PartTree(queryMethod.getName(), repositoryInformation.getDomainType());
            AotStringQuery aotStringQuery = this.queryCreator.createQuery(partTree, queryMethod, source);
            query = new QueryInteraction(aotStringQuery, partTree.isCountProjection(), partTree.isDelete(), partTree.isExistsProjection());
        }
        if (queryAnnotation != null && StringUtils.hasText((String)queryAnnotation.sort())) {
            query = query.withSort(queryAnnotation.sort());
        }
        if (queryAnnotation != null && StringUtils.hasText((String)queryAnnotation.fields())) {
            query = query.withFields(queryAnnotation.fields());
        }
        return query;
    }

    private static boolean backoff(MongoQueryMethod method) {
        boolean skip = method.getReturnType().getType().isArray();
        if (skip && logger.isDebugEnabled()) {
            logger.debug((Object)"Skipping AOT generation for [%s]. Method is either returning an array or a geo-near, regex query".formatted(method.getName()));
        }
        return skip;
    }

    private static MethodContributor.RepositoryMethodContribution nearQueryMethodContributor(MongoQueryMethod queryMethod, NearQueryInteraction interaction) {
        return context -> {
            CodeBlock.Builder builder = CodeBlock.builder();
            String variableName = context.localVariable("nearQuery");
            builder.add(MongoCodeBlocks.geoNearBlockBuilder(context, queryMethod).usingQueryVariableName(variableName).build());
            if (!context.getBindableParameterNames().isEmpty()) {
                String filterQueryVariableName = context.localVariable("filterQuery");
                builder.add(MongoCodeBlocks.queryBlockBuilder(context, queryMethod).usingQueryVariableName(filterQueryVariableName).filter(interaction.getQuery()).build());
                builder.addStatement("$L.query($L)", new Object[]{variableName, filterQueryVariableName});
            }
            builder.add(MongoCodeBlocks.geoNearExecutionBlockBuilder(context).referencing(variableName).build());
            return builder.build();
        };
    }

    static MethodContributor.RepositoryMethodContribution aggregationMethodContributor(MongoQueryMethod queryMethod, SimpleTypeHolder simpleTypeHolder, AggregationInteraction aggregation) {
        return context -> {
            CodeBlock.Builder builder = CodeBlock.builder();
            String variableName = context.localVariable("aggregation");
            builder.add(MongoCodeBlocks.aggregationBlockBuilder(context, simpleTypeHolder, queryMethod).stages(aggregation).usingAggregationVariableName(variableName).build());
            builder.add(MongoCodeBlocks.aggregationExecutionBlockBuilder(context, simpleTypeHolder, queryMethod).referencing(variableName).build());
            return builder.build();
        };
    }

    static MethodContributor.RepositoryMethodContribution searchMethodContributor(MongoQueryMethod queryMethod, SearchInteraction interaction) {
        return context -> {
            CodeBlock.Builder builder = CodeBlock.builder();
            String variableName = context.localVariable("search");
            builder.add(new VectorSearchBlocks.VectorSearchQueryCodeBlockBuilder(context, queryMethod, interaction.getSearchPath()).usingVariableName(variableName).withFilter(interaction.getFilter()).build());
            return builder.build();
        };
    }

    static MethodContributor.RepositoryMethodContribution updateMethodContributor(MongoQueryMethod queryMethod, UpdateInteraction update) {
        return context -> {
            String updateVariableName;
            CodeBlock.Builder builder = CodeBlock.builder();
            String filterVariableName = context.localVariable(update.name());
            builder.add(MongoCodeBlocks.queryBlockBuilder(context, queryMethod).filter(update.getFilter()).usingQueryVariableName(filterVariableName).build());
            if (update.hasUpdateDefinitionParameter()) {
                updateVariableName = context.getParameterName(update.getRequiredUpdateDefinitionParameter());
            } else {
                updateVariableName = context.localVariable("updateDefinition");
                builder.add(MongoCodeBlocks.updateBlockBuilder(context).update(update).usingUpdateVariableName(updateVariableName).build());
            }
            builder.add(MongoCodeBlocks.updateExecutionBlockBuilder(context, queryMethod).withFilter(filterVariableName).referencingUpdate(updateVariableName).build());
            return builder.build();
        };
    }

    static MethodContributor.RepositoryMethodContribution aggregationUpdateMethodContributor(MongoQueryMethod queryMethod, SimpleTypeHolder simpleTypeHolder, AggregationUpdateInteraction update) {
        return context -> {
            CodeBlock.Builder builder = CodeBlock.builder();
            String filterVariableName = context.localVariable(update.name());
            QueryBlocks.QueryCodeBlockBuilder queryCodeBlockBuilder = MongoCodeBlocks.queryBlockBuilder(context, queryMethod).filter(update.getFilter());
            builder.add(queryCodeBlockBuilder.usingQueryVariableName(filterVariableName).build());
            String updateVariableName = context.localVariable("updateDefinition");
            builder.add(MongoCodeBlocks.aggregationBlockBuilder(context, simpleTypeHolder, queryMethod).stages(update).usingAggregationVariableName(updateVariableName).pipelineOnly(true).build());
            builder.addStatement("$T $L = $T.from($L.getOperations())", new Object[]{AggregationUpdate.class, context.localVariable("aggregationUpdate"), AggregationUpdate.class, updateVariableName});
            builder.add(MongoCodeBlocks.updateExecutionBlockBuilder(context, queryMethod).withFilter(filterVariableName).referencingUpdate(context.localVariable("aggregationUpdate")).build());
            return builder.build();
        };
    }

    static MethodContributor.RepositoryMethodContribution deleteMethodContributor(MongoQueryMethod queryMethod, QueryInteraction query) {
        return context -> {
            CodeBlock.Builder builder = CodeBlock.builder();
            QueryBlocks.QueryCodeBlockBuilder queryCodeBlockBuilder = MongoCodeBlocks.queryBlockBuilder(context, queryMethod).filter(query);
            String queryVariableName = context.localVariable(query.name());
            builder.add(queryCodeBlockBuilder.usingQueryVariableName(queryVariableName).build());
            builder.add(MongoCodeBlocks.deleteExecutionBlockBuilder(context, queryMethod).referencing(queryVariableName).build());
            return builder.build();
        };
    }

    static MethodContributor.RepositoryMethodContribution queryMethodContributor(MongoQueryMethod queryMethod, QueryInteraction query) {
        return context -> {
            CodeBlock.Builder builder = CodeBlock.builder();
            QueryBlocks.QueryCodeBlockBuilder queryCodeBlockBuilder = MongoCodeBlocks.queryBlockBuilder(context, queryMethod).filter(query);
            builder.add(queryCodeBlockBuilder.usingQueryVariableName(context.localVariable(query.name())).build());
            builder.add(MongoCodeBlocks.queryExecutionBlockBuilder(context, queryMethod).forQuery(query).build());
            return builder.build();
        };
    }
}

